/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;

public final class ThreeBags<E0, E1, E2> {
    private final Collection<E0> bag0;
    private final Collection<E1> bag1;
    private final Collection<E2> bag2;

    private ThreeBags(@Nonnull Collection<E0> bag0, @Nonnull Collection<E1> bag1, @Nonnull Collection<E2> bag2) {
        this.bag0 = new ArrayList<E0>(bag0);
        this.bag1 = new ArrayList<E1>(bag1);
        this.bag2 = new ArrayList<E2>(bag2);
    }

    @Nonnull
    public static <E0, E1, E2> ThreeBags<E0, E1, E2> threeBags() {
        return new ThreeBags(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Nonnull
    public static <E0, E1, E2> ThreeBags<E0, E1, E2> threeBags(@Nonnull Collection<E0> bag0, @Nonnull Collection<E1> bag1, @Nonnull Collection<E2> bag2) {
        return new ThreeBags<E0, E1, E2>(bag0, bag1, bag2);
    }

    @Nonnull
    public Collection<E0> bag0() {
        return this.bag0;
    }

    @Nonnull
    public Collection<E1> bag1() {
        return this.bag1;
    }

    @Nonnull
    public Collection<E2> bag2() {
        return this.bag2;
    }

    public void combineWith(@Nonnull ThreeBags<E0, E1, E2> that) {
        this.bag0.addAll(that.bag0());
        this.bag1.addAll(that.bag1());
        this.bag2.addAll(that.bag2());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ThreeBags)) return false;
        ThreeBags that = (ThreeBags)o;
        if (!this.bag0.equals(that.bag0)) return false;
        if (!this.bag1.equals(that.bag1)) return false;
        if (!this.bag2.equals(that.bag2)) return false;
        return true;
    }

    public int hashCode() {
        int hc = this.bag0.hashCode();
        hc = 73 * hc + this.bag1.hashCode();
        hc = 73 * hc + this.bag2.hashCode();
        return hc;
    }

    public String toString() {
        return "ThreeBags{" + this.bag0 + ", " + this.bag1 + ", " + this.bag2 + '}';
    }
}

