/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.test;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.impl.execution.OutboundCollector;
import com.hazelcast.jet.impl.execution.OutboxImpl;
import com.hazelcast.jet.impl.util.ProgressState;
import com.hazelcast.jet.impl.util.ProgressTracker;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Preconditions;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nonnull;

public final class TestOutbox
implements Outbox {
    private static final SerializationService IDENTITY_SERIALIZER = new MockSerializationService();
    private final Queue<Object>[] buckets;
    private final Queue<Map.Entry<MockData, MockData>> snapshotQueue = new ArrayDeque<Map.Entry<MockData, MockData>>();
    private final OutboxImpl outbox;

    public TestOutbox(int ... capacities) {
        this(capacities, 0);
    }

    public TestOutbox(int[] edgeCapacities, int snapshotCapacity) {
        Preconditions.checkNotNegative((int)snapshotCapacity, (String)"snapshotCapacity must be >= 0 (0 for no snapshot queue)");
        this.buckets = new Queue[edgeCapacities.length];
        Arrays.setAll(this.buckets, i -> new ArrayDeque());
        OutboundCollector[] outstreams = new OutboundCollector[edgeCapacities.length + (snapshotCapacity > 0 ? 1 : 0)];
        Arrays.setAll(outstreams, i -> i < edgeCapacities.length ? e -> TestOutbox.addToQueue(this.buckets[i], edgeCapacities[i], e) : e -> TestOutbox.addToQueue(this.snapshotQueue, snapshotCapacity, (Map.Entry)e));
        this.outbox = new OutboxImpl(outstreams, snapshotCapacity > 0, new ProgressTracker(), IDENTITY_SERIALIZER, Integer.MAX_VALUE);
        this.outbox.resetBatch();
    }

    private static <E> ProgressState addToQueue(Queue<? super E> queue, int capacity, E o) {
        if (capacity > queue.size()) {
            queue.offer(o);
            return ProgressState.DONE;
        }
        return ProgressState.NO_PROGRESS;
    }

    @Override
    public int bucketCount() {
        return this.outbox.bucketCount();
    }

    @Override
    public boolean offer(int ordinal, @Nonnull Object item) {
        return this.outbox.offer(ordinal, item);
    }

    @Override
    public boolean offer(int[] ordinals, @Nonnull Object item) {
        return this.outbox.offer(ordinals, item);
    }

    @Override
    public boolean offer(@Nonnull Object item) {
        return this.outbox.offer(item);
    }

    public String toString() {
        return Arrays.toString(this.buckets);
    }

    @Override
    public boolean offerToSnapshot(Object key, Object value) {
        return this.outbox.offerToSnapshot(key, value);
    }

    public Queue<Object> queueWithOrdinal(int ordinal) {
        return this.buckets[ordinal];
    }

    public Queue<Map.Entry<MockData, MockData>> snapshotQueue() {
        return this.snapshotQueue;
    }

    public static class MockData
    implements Data {
        private final Object object;

        public MockData(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public byte[] toByteArray() {
            throw new UnsupportedOperationException();
        }

        public int getType() {
            throw new UnsupportedOperationException();
        }

        public int totalSize() {
            throw new UnsupportedOperationException();
        }

        public void copyTo(byte[] dest, int destPos) {
            throw new UnsupportedOperationException();
        }

        public int dataSize() {
            throw new UnsupportedOperationException();
        }

        public int getHeapCost() {
            throw new UnsupportedOperationException();
        }

        public int getPartitionHash() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPartitionHash() {
            throw new UnsupportedOperationException();
        }

        public long hash64() {
            throw new UnsupportedOperationException();
        }

        public boolean isPortable() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MockSerializationService
    implements SerializationService {
        public <B extends Data> B toData(Object obj) {
            return (B)new MockData(obj);
        }

        public <B extends Data> B toData(Object obj, PartitioningStrategy strategy) {
            return (B)new MockData(obj);
        }

        public <T> T toObject(Object data) {
            throw new UnsupportedOperationException();
        }

        public <T> T toObject(Object data, Class klazz) {
            throw new UnsupportedOperationException();
        }

        public ManagedContext getManagedContext() {
            throw new UnsupportedOperationException();
        }
    }
}

