/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.processor;

import com.hazelcast.cache.journal.EventJournalCacheEvent;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.impl.connector.ReadFilesP;
import com.hazelcast.jet.impl.connector.ReadIListP;
import com.hazelcast.jet.impl.connector.ReadWithPartitionIteratorP;
import com.hazelcast.jet.impl.connector.StreamEventJournalP;
import com.hazelcast.jet.impl.connector.StreamFilesP;
import com.hazelcast.jet.impl.connector.StreamSocketP;
import com.hazelcast.map.journal.EventJournalMapEvent;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SourceProcessors {
    private SourceProcessors() {
    }

    @Nonnull
    public static ProcessorMetaSupplier readMapP(@Nonnull String mapName) {
        return ReadWithPartitionIteratorP.readMapP(mapName);
    }

    @Nonnull
    public static <K, V, T> ProcessorMetaSupplier readMapP(@Nonnull String mapName, @Nonnull Predicate<K, V> predicate, @Nonnull Projection<Map.Entry<K, V>, T> projectionFn) {
        return ReadWithPartitionIteratorP.readMapP(mapName, predicate, projectionFn);
    }

    @Nonnull
    public static <K, V, T> ProcessorMetaSupplier readMapP(@Nonnull String mapName, @Nonnull Predicate<K, V> predicate, @Nonnull DistributedFunction<Map.Entry<K, V>, T> projectionFn) {
        return ReadWithPartitionIteratorP.readMapP(mapName, predicate, SourceProcessors.toProjection(projectionFn));
    }

    @Nonnull
    public static ProcessorMetaSupplier streamMapP(@Nonnull String mapName, boolean startFromLatestSequence) {
        return StreamEventJournalP.streamMapP(mapName, null, null, startFromLatestSequence);
    }

    @Nonnull
    public static <K, V, T> ProcessorMetaSupplier streamMapP(@Nonnull String mapName, @Nullable DistributedPredicate<EventJournalMapEvent<K, V>> predicate, @Nullable DistributedFunction<EventJournalMapEvent<K, V>, T> projection, boolean startFromLatestSequence) {
        return StreamEventJournalP.streamMapP(mapName, predicate, projection, startFromLatestSequence);
    }

    @Nonnull
    public static ProcessorMetaSupplier readRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return ReadWithPartitionIteratorP.readRemoteMapP(mapName, clientConfig);
    }

    @Nonnull
    public static <K, V, T> ProcessorMetaSupplier readRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<K, V> predicate, @Nonnull Projection<Map.Entry<K, V>, T> projection) {
        return ReadWithPartitionIteratorP.readRemoteMapP(mapName, clientConfig, projection, predicate);
    }

    @Nonnull
    public static <K, V, T> ProcessorMetaSupplier readRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<K, V> predicate, @Nonnull DistributedFunction<Map.Entry<K, V>, T> projectionFn) {
        return ReadWithPartitionIteratorP.readRemoteMapP(mapName, clientConfig, SourceProcessors.toProjection(projectionFn), predicate);
    }

    @Nonnull
    public static ProcessorMetaSupplier streamRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, boolean startFromLatestSequence) {
        return StreamEventJournalP.streamRemoteMapP(mapName, clientConfig, null, null, startFromLatestSequence);
    }

    @Nonnull
    public static <K, V, T> ProcessorMetaSupplier streamRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nullable DistributedPredicate<EventJournalMapEvent<K, V>> predicate, @Nullable DistributedFunction<EventJournalMapEvent<K, V>, T> projection, boolean startFromLatestSequence) {
        return StreamEventJournalP.streamRemoteMapP(mapName, clientConfig, predicate, projection, startFromLatestSequence);
    }

    @Nonnull
    public static ProcessorMetaSupplier readCacheP(@Nonnull String cacheName) {
        return ReadWithPartitionIteratorP.readCacheP(cacheName);
    }

    @Nonnull
    public static ProcessorMetaSupplier streamCacheP(@Nonnull String cacheName, boolean startFromLatestSequence) {
        return StreamEventJournalP.streamCacheP(cacheName, null, null, startFromLatestSequence);
    }

    @Nonnull
    public static <K, V, T> ProcessorMetaSupplier streamCacheP(@Nonnull String cacheName, @Nullable DistributedPredicate<EventJournalCacheEvent<K, V>> predicate, @Nullable DistributedFunction<EventJournalCacheEvent<K, V>, T> projection, boolean startFromLatestSequence) {
        return StreamEventJournalP.streamCacheP(cacheName, predicate, projection, startFromLatestSequence);
    }

    @Nonnull
    public static ProcessorMetaSupplier readRemoteCacheP(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return ReadWithPartitionIteratorP.readRemoteCacheP(cacheName, clientConfig);
    }

    @Nonnull
    public static ProcessorMetaSupplier streamRemoteCacheP(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig, boolean startFromLatestSequence) {
        return StreamEventJournalP.streamRemoteCacheP(cacheName, clientConfig, null, null, startFromLatestSequence);
    }

    @Nonnull
    public static <K, V, T> ProcessorMetaSupplier streamRemoteCacheP(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig, @Nullable DistributedPredicate<EventJournalCacheEvent<K, V>> predicate, @Nullable DistributedFunction<EventJournalCacheEvent<K, V>, T> projection, boolean startFromLatestSequence) {
        return StreamEventJournalP.streamRemoteCacheP(cacheName, clientConfig, predicate, projection, startFromLatestSequence);
    }

    @Nonnull
    public static ProcessorMetaSupplier readListP(@Nonnull String listName) {
        return ReadIListP.metaSupplier(listName, null);
    }

    @Nonnull
    public static ProcessorMetaSupplier readRemoteListP(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return ReadIListP.metaSupplier(listName, clientConfig);
    }

    @Nonnull
    public static ProcessorMetaSupplier streamSocketP(@Nonnull String host, int port, @Nonnull Charset charset) {
        return StreamSocketP.supplier(host, port, charset.name());
    }

    @Nonnull
    public static ProcessorMetaSupplier readFilesP(@Nonnull String directory, @Nonnull Charset charset, @Nonnull String glob) {
        return ReadFilesP.metaSupplier(directory, charset.name(), glob);
    }

    public static ProcessorMetaSupplier streamFilesP(@Nonnull String watchedDirectory, @Nonnull Charset charset, @Nonnull String glob) {
        return StreamFilesP.metaSupplier(watchedDirectory, charset.name(), glob);
    }

    private static <I, O> Projection<I, O> toProjection(final DistributedFunction<I, O> projectionFn) {
        return new Projection<I, O>(){

            public O transform(I input) {
                return projectionFn.apply(input);
            }
        };
    }
}

