/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.core.WindowDefinition;
import com.hazelcast.util.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface WatermarkEmissionPolicy
extends Serializable {
    public boolean shouldEmit(long var1, long var3);

    @Nonnull
    public static WatermarkEmissionPolicy suppressDuplicates() {
        return (currentWm, lastEmittedWm) -> currentWm > lastEmittedWm;
    }

    @Nonnull
    public static WatermarkEmissionPolicy emitByMinStep(long minStep) {
        Preconditions.checkPositive((long)minStep, (String)"minStep");
        return (currentWm, lastEmittedWm) -> currentWm >= lastEmittedWm + minStep;
    }

    @Nonnull
    public static WatermarkEmissionPolicy emitByFrame(WindowDefinition wDef) {
        return (currentWm, lastEmittedWm) -> wDef.floorFrameTs(currentWm) > lastEmittedWm;
    }
}

