/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class JobConfig
implements Serializable {
    private static final int SNAPSHOT_INTERVAL_MILLIS_DEFAULT = 10000;
    private ProcessingGuarantee processingGuarantee = ProcessingGuarantee.NONE;
    private long snapshotIntervalMillis = 10000L;
    private boolean splitBrainProtectionEnabled;
    private final List<ResourceConfig> resourceConfigs = new ArrayList<ResourceConfig>();
    private boolean autoRestartEnabled = true;

    public boolean isSplitBrainProtectionEnabled() {
        return this.splitBrainProtectionEnabled;
    }

    public JobConfig setSplitBrainProtection(boolean isEnabled) {
        this.splitBrainProtectionEnabled = isEnabled;
        return this;
    }

    public boolean isAutoRestartOnMemberFailureEnabled() {
        return this.autoRestartEnabled;
    }

    public JobConfig setAutoRestartOnMemberFailure(boolean isEnabled) {
        this.autoRestartEnabled = isEnabled;
        return this;
    }

    public ProcessingGuarantee getProcessingGuarantee() {
        return this.processingGuarantee;
    }

    public JobConfig setProcessingGuarantee(ProcessingGuarantee processingGuarantee) {
        this.processingGuarantee = processingGuarantee;
        return this;
    }

    public long getSnapshotIntervalMillis() {
        return this.snapshotIntervalMillis;
    }

    public JobConfig setSnapshotIntervalMillis(long snapshotInterval) {
        Preconditions.checkPositive((long)snapshotInterval, (String)"snapshotInterval must be positive");
        this.snapshotIntervalMillis = snapshotInterval;
        return this;
    }

    public JobConfig addClass(Class ... classes) {
        Preconditions.checkNotNull((Object)classes, (String)"Classes can not be null");
        for (Class clazz : classes) {
            this.resourceConfigs.add(new ResourceConfig(clazz));
        }
        return this;
    }

    public JobConfig addJar(URL url) {
        return this.add(url, null, true);
    }

    public JobConfig addJar(File file) {
        try {
            return this.addJar(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public JobConfig addJar(String path) {
        try {
            File file = new File(path);
            return this.addJar(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public JobConfig addResource(URL url) {
        return this.addResource(url, JobConfig.toFilename(url));
    }

    public JobConfig addResource(URL url, String id) {
        return this.add(url, id, false);
    }

    public JobConfig addResource(File file) {
        try {
            return this.addResource(file.toURI().toURL(), file.getName());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public JobConfig addResource(File file, String id) {
        try {
            return this.add(file.toURI().toURL(), id, false);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public JobConfig addResource(String path) {
        return this.addResource(new File(path));
    }

    public JobConfig addResource(String path, String id) {
        return this.addResource(new File(path), id);
    }

    public List<ResourceConfig> getResourceConfigs() {
        return this.resourceConfigs;
    }

    private JobConfig add(URL url, String id, boolean isJar) {
        this.resourceConfigs.add(new ResourceConfig(url, id, isJar));
        return this;
    }

    private static String toFilename(URL url) {
        String urlFile = url.getPath();
        return urlFile.substring(urlFile.lastIndexOf(47) + 1, urlFile.length());
    }
}

