/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import javax.annotation.Nonnull;

public class InstanceConfig {
    public static final int DEFAULT_FLOW_CONTROL_PERIOD_MS = 100;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    private int cooperativeThreadCount = Runtime.getRuntime().availableProcessors();
    private int flowControlPeriodMs = 100;
    private int backupCount = 1;
    private String tempDir;

    public InstanceConfig setCooperativeThreadCount(int size) {
        this.cooperativeThreadCount = size;
        return this;
    }

    public int getCooperativeThreadCount() {
        return this.cooperativeThreadCount;
    }

    public InstanceConfig setTempDir(String tempDir) {
        this.tempDir = tempDir;
        return this;
    }

    @Nonnull
    public String getTempDir() {
        return this.tempDir == null ? System.getProperty("java.io.tmpdir") : this.tempDir;
    }

    public InstanceConfig setFlowControlPeriodMs(int flowControlPeriodMs) {
        this.flowControlPeriodMs = flowControlPeriodMs;
        return this;
    }

    public int getFlowControlPeriodMs() {
        return this.flowControlPeriodMs;
    }

    public InstanceConfig setBackupCount(int newBackupCount) {
        if (newBackupCount < 0) {
            throw new IllegalArgumentException("backup count can't be smaller than 0");
        }
        if (newBackupCount > 6) {
            throw new IllegalArgumentException("backup count can't be larger than than 6");
        }
        this.backupCount = newBackupCount;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }
}

