/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.aggregate;

import com.hazelcast.jet.accumulator.DoubleAccumulator;
import com.hazelcast.jet.accumulator.LinTrendAccumulator;
import com.hazelcast.jet.accumulator.LongAccumulator;
import com.hazelcast.jet.accumulator.LongDoubleAccumulator;
import com.hazelcast.jet.accumulator.LongLongAccumulator;
import com.hazelcast.jet.accumulator.MutableReference;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedBinaryOperator;
import com.hazelcast.jet.function.DistributedComparator;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.function.DistributedToDoubleFunction;
import com.hazelcast.jet.function.DistributedToLongFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AggregateOperations {
    private AggregateOperations() {
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LongAccumulator, Long> counting() {
        return AggregateOperation.withCreate(LongAccumulator::new).andAccumulate((a, item) -> a.addExact(1L)).andCombine(LongAccumulator::addExact).andDeduct(LongAccumulator::subtract).andFinish(LongAccumulator::get);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LongAccumulator, Long> summingLong(@Nonnull DistributedToLongFunction<T> getLongValueFn) {
        return AggregateOperation.withCreate(LongAccumulator::new).andAccumulate((a, item) -> a.addExact(getLongValueFn.applyAsLong(item))).andCombine(LongAccumulator::addExact).andDeduct(LongAccumulator::subtractExact).andFinish(LongAccumulator::get);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, DoubleAccumulator, Double> summingDouble(@Nonnull DistributedToDoubleFunction<T> getDoubleValueFn) {
        return AggregateOperation.withCreate(DoubleAccumulator::new).andAccumulate((a, item) -> a.add(getDoubleValueFn.applyAsDouble(item))).andCombine(DoubleAccumulator::add).andDeduct(DoubleAccumulator::subtract).andFinish(DoubleAccumulator::get);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, MutableReference<T>, T> minBy(@Nonnull DistributedComparator<? super T> comparator) {
        return AggregateOperations.maxBy(comparator.reversed());
    }

    @Nonnull
    public static <T> AggregateOperation1<T, MutableReference<T>, T> maxBy(@Nonnull DistributedComparator<? super T> comparator) {
        return AggregateOperation.withCreate(MutableReference::new).andAccumulate((a, i) -> {
            if (a.get() == null || comparator.compare(i, a.get()) > 0) {
                a.set(i);
            }
        }).andCombine((a1, a2) -> {
            if (a1.get() == null || comparator.compare((Object)a1.get(), (Object)a2.get()) < 0) {
                a1.set(a2.get());
            }
        }).andFinish(MutableReference::get);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LongLongAccumulator, Double> averagingLong(@Nonnull DistributedToLongFunction<T> getLongValueFn) {
        return AggregateOperation.withCreate(LongLongAccumulator::new).andAccumulate((a, i) -> {
            if (a.getValue1() == Long.MAX_VALUE) {
                throw new ArithmeticException("Counter overflow");
            }
            a.setValue1(a.getValue1() + 1L);
            a.setValue2(Math.addExact(a.getValue2(), getLongValueFn.applyAsLong(i)));
        }).andCombine((a1, a2) -> {
            a1.setValue1(Math.addExact(a1.getValue1(), a2.getValue1()));
            a1.setValue2(Math.addExact(a1.getValue2(), a2.getValue2()));
        }).andDeduct((a1, a2) -> {
            a1.setValue1(Math.subtractExact(a1.getValue1(), a2.getValue1()));
            a1.setValue2(Math.subtractExact(a1.getValue2(), a2.getValue2()));
        }).andFinish(a -> (double)a.getValue2() / (double)a.getValue1());
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LongDoubleAccumulator, Double> averagingDouble(@Nonnull DistributedToDoubleFunction<T> getDoubleValueFn) {
        return AggregateOperation.withCreate(LongDoubleAccumulator::new).andAccumulate((a, item) -> {
            if (a.getValue1() == Long.MAX_VALUE) {
                throw new ArithmeticException("Counter overflow");
            }
            a.setValue1(a.getValue1() + 1L);
            a.setValue2(a.getValue2() + getDoubleValueFn.applyAsDouble(item));
        }).andCombine((a1, a2) -> {
            a1.setValue1(Math.addExact(a1.getValue1(), a2.getValue1()));
            a1.setValue2(a1.getValue2() + a2.getValue2());
        }).andDeduct((a1, a2) -> {
            a1.setValue1(Math.subtractExact(a1.getValue1(), a2.getValue1()));
            a1.setValue2(a1.getValue2() - a2.getValue2());
        }).andFinish(a -> a.getValue2() / (double)a.getValue1());
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LinTrendAccumulator, Double> linearTrend(@Nonnull DistributedToLongFunction<T> getXFn, @Nonnull DistributedToLongFunction<T> getYFn) {
        return AggregateOperation.withCreate(LinTrendAccumulator::new).andAccumulate((a, item) -> a.accumulate(getXFn.applyAsLong(item), getYFn.applyAsLong(item))).andCombine(LinTrendAccumulator::combine).andDeduct(LinTrendAccumulator::deduct).andFinish(LinTrendAccumulator::finish);
    }

    @SafeVarargs
    @Nonnull
    public static <T> AggregateOperation1<T, List<Object>, List<Object>> allOf(AggregateOperation1<? super T, ?, ?> ... operations) {
        AggregateOperation1[] untypedOps = operations;
        return AggregateOperation.withCreate(() -> {
            ArrayList res = new ArrayList(untypedOps.length);
            for (AggregateOperation1 untypedOp : untypedOps) {
                res.add(untypedOp.createFn().get());
            }
            return res;
        }).andAccumulate((accs, item) -> {
            for (int i = 0; i < untypedOps.length; ++i) {
                untypedOps[i].accumulateFn().accept(accs.get(i), item);
            }
        }).andCombine(Stream.of(untypedOps).allMatch(o -> o.combineFn() != null) ? (accs1, accs2) -> {
            for (int i = 0; i < untypedOps.length; ++i) {
                untypedOps[i].combineFn().accept(accs1.get(i), accs2.get(i));
            }
        } : null).andDeduct(Stream.of(untypedOps).allMatch(o -> o.deductFn() != null) ? (accs1, accs2) -> {
            for (int i = 0; i < untypedOps.length; ++i) {
                untypedOps[i].deductFn().accept(accs1.get(i), accs2.get(i));
            }
        } : null).andFinish(accs -> {
            ArrayList res = new ArrayList(untypedOps.length);
            for (int i = 0; i < untypedOps.length; ++i) {
                res.add(untypedOps[i].finishFn().apply(accs.get(i)));
            }
            return res;
        });
    }

    public static <T, U, A, R> AggregateOperation1<T, ?, R> mapping(@Nonnull DistributedFunction<? super T, ? extends U> mapFn, @Nonnull AggregateOperation1<? super U, A, R> downstream) {
        DistributedBiConsumer downstreamAccumulateFn = downstream.accumulateFn();
        return AggregateOperation.withCreate(downstream.createFn()).andAccumulate((a, t) -> {
            Object mapped = mapFn.apply(t);
            if (mapped != null) {
                downstreamAccumulateFn.accept((Object)a, (Object)mapped);
            }
        }).andCombine(downstream.combineFn()).andDeduct(downstream.deductFn()).andFinish(downstream.finishFn());
    }

    public static <T, C extends Collection<T>> AggregateOperation1<T, C, C> toCollection(DistributedSupplier<C> createCollectionFn) {
        return AggregateOperation.withCreate(createCollectionFn).andAccumulate(Collection::add).andCombine(Collection::addAll).andIdentityFinish();
    }

    public static <T> AggregateOperation1<T, List<T>, List<T>> toList() {
        return AggregateOperations.toCollection(ArrayList::new);
    }

    public static <T> AggregateOperation1<T, ?, Set<T>> toSet() {
        return AggregateOperations.toCollection(HashSet::new);
    }

    public static <T, K, U> AggregateOperation1<T, Map<K, U>, Map<K, U>> toMap(DistributedFunction<? super T, ? extends K> getKeyFn, DistributedFunction<? super T, ? extends U> getValueFn) {
        return AggregateOperations.toMap(getKeyFn, getValueFn, AggregateOperations.throwingMerger(), HashMap::new);
    }

    public static <T, K, U> AggregateOperation1<T, Map<K, U>, Map<K, U>> toMap(DistributedFunction<? super T, ? extends K> getKeyFn, DistributedFunction<? super T, ? extends U> getValueFn, DistributedBinaryOperator<U> mergeFn) {
        return AggregateOperations.toMap(getKeyFn, getValueFn, mergeFn, HashMap::new);
    }

    public static <T, K, U, M extends Map<K, U>> AggregateOperation1<T, M, M> toMap(DistributedFunction<? super T, ? extends K> getKeyFn, DistributedFunction<? super T, ? extends U> getValueFn, DistributedBinaryOperator<U> mergeFn, DistributedSupplier<M> createMapFn) {
        DistributedBiConsumer accumulateFn = (map, element) -> map.merge(getKeyFn.apply(element), getValueFn.apply(element), mergeFn);
        return AggregateOperation.withCreate(createMapFn).andAccumulate(accumulateFn).andCombine(AggregateOperations.mapMerger(mergeFn)).andIdentityFinish();
    }

    private static <T> DistributedBinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException("Duplicate key: " + u);
        };
    }

    private static <K, V, M extends Map<K, V>> DistributedBiConsumer<M, M> mapMerger(DistributedBinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
        };
    }

    @Nonnull
    public static <T, A> AggregateOperation1<T, MutableReference<A>, A> reducing(@Nonnull A emptyAccValue, @Nonnull DistributedFunction<? super T, ? extends A> toAccValueFn, @Nonnull DistributedBinaryOperator<A> combineAccValuesFn, @Nullable DistributedBinaryOperator<A> deductAccValueFn) {
        return AggregateOperation.withCreate(() -> new MutableReference<Object>(emptyAccValue)).andAccumulate((a, t) -> a.set(combineAccValuesFn.apply(a.get(), toAccValueFn.apply(t)))).andCombine((a, b) -> a.set(combineAccValuesFn.apply(a.get(), b.get()))).andDeduct(deductAccValueFn != null ? (a, b) -> a.set(deductAccValueFn.apply(a.get(), b.get())) : null).andFinish(MutableReference::get);
    }
}

