/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.aggregate;

import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.aggregate.AggregateOperation1Impl;
import com.hazelcast.jet.impl.aggregate.AggregateOperation2Impl;
import com.hazelcast.jet.impl.aggregate.AggregateOperation3Impl;
import com.hazelcast.jet.impl.aggregate.AggregateOperationImpl;
import com.hazelcast.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class AggregateOperationBuilder<A> {
    @Nonnull
    private final DistributedSupplier<A> createFn;

    AggregateOperationBuilder(@Nonnull DistributedSupplier<A> createFn) {
        this.createFn = createFn;
    }

    @Nonnull
    public <T> Arity1<T, A> andAccumulate(@Nonnull DistributedBiConsumer<? super A, T> accumulateFn) {
        return new Arity1<T, A>(this.createFn, accumulateFn);
    }

    @Nonnull
    public <T0> Arity1<T0, A> andAccumulate0(@Nonnull DistributedBiConsumer<? super A, T0> accumulateFn0) {
        return new Arity1<T0, A>(this.createFn, accumulateFn0);
    }

    @Nonnull
    public <T> VarArity<A> andAccumulate(@Nonnull Tag<T> tag, @Nonnull DistributedBiConsumer<? super A, T> accumulateFn) {
        return new VarArity<A>(this.createFn, tag, accumulateFn);
    }

    public static class VarArity<A> {
        @Nonnull
        private final DistributedSupplier<A> createFn;
        private final Map<Integer, DistributedBiConsumer<? super A, ?>> accumulateFnsByTag = new HashMap();
        private DistributedBiConsumer<? super A, ? super A> combineFn;
        private DistributedBiConsumer<? super A, ? super A> deductFn;

        <T> VarArity(@Nonnull DistributedSupplier<A> createFn, @Nonnull Tag<T> tag, @Nonnull DistributedBiConsumer<? super A, T> accumulateFn) {
            this.createFn = createFn;
            this.accumulateFnsByTag.put(tag.index(), accumulateFn);
        }

        @Nonnull
        public <T> VarArity<A> andAccumulate(@Nonnull Tag<T> tag, @Nonnull DistributedBiConsumer<? super A, T> accumulateFn) {
            this.accumulateFnsByTag.merge(tag.index(), accumulateFn, (x, y) -> {
                throw new IllegalArgumentException("Tag with index " + tag.index() + " already registered");
            });
            return this;
        }

        @Nonnull
        public VarArity<A> andCombine(DistributedBiConsumer<? super A, ? super A> combineFn) {
            this.combineFn = combineFn;
            return this;
        }

        @Nonnull
        public VarArity<A> andDeduct(DistributedBiConsumer<? super A, ? super A> deductFn) {
            this.deductFn = deductFn;
            return this;
        }

        @Nonnull
        public <R> AggregateOperation<A, R> andFinish(@Nonnull DistributedFunction<? super A, R> finishFn) {
            Preconditions.checkNotNull(finishFn, (String)"finishFn");
            return new AggregateOperationImpl<A, R>(this.createFn, this.packAccumulateFns(), this.combineFn, this.deductFn, finishFn);
        }

        @Nonnull
        public AggregateOperation<A, A> andIdentityFinish() {
            return new AggregateOperationImpl(this.createFn, this.packAccumulateFns(), this.combineFn, this.deductFn, DistributedFunction.identity());
        }

        private DistributedBiConsumer<? super A, ?>[] packAccumulateFns() {
            int size = this.accumulateFnsByTag.size();
            DistributedBiConsumer[] accFs = new DistributedBiConsumer[size];
            for (int i = 0; i < size; ++i) {
                accFs[i] = this.accumulateFnsByTag.get(i);
                if (accFs[i] != null) continue;
                throw new IllegalStateException("Registered tags' indices are " + this.accumulateFnsByTag.keySet().stream().sorted().collect(Collectors.toList()) + " but should be " + IntStream.range(0, size).boxed().collect(Collectors.toList()));
            }
            return accFs;
        }
    }

    public static class Arity3<T0, T1, T2, A> {
        @Nonnull
        private final DistributedSupplier<A> createFn;
        @Nonnull
        private final DistributedBiConsumer<? super A, T0> accumulateFn0;
        @Nonnull
        private final DistributedBiConsumer<? super A, T1> accumulateFn1;
        @Nonnull
        private final DistributedBiConsumer<? super A, T2> accumulateFn2;
        private DistributedBiConsumer<? super A, ? super A> combineFn;
        private DistributedBiConsumer<? super A, ? super A> deductFn;

        Arity3(Arity2<T0, T1, A> step2, DistributedBiConsumer<? super A, T2> accumulateFn2) {
            this.createFn = ((Arity2)step2).createFn;
            this.accumulateFn0 = ((Arity2)step2).accumulateFn0;
            this.accumulateFn1 = ((Arity2)step2).accumulateFn1;
            this.accumulateFn2 = accumulateFn2;
        }

        @Nonnull
        public Arity3<T0, T1, T2, A> andCombine(DistributedBiConsumer<? super A, ? super A> combineFn) {
            this.combineFn = combineFn;
            return this;
        }

        @Nonnull
        public Arity3<T0, T1, T2, A> andDeduct(DistributedBiConsumer<? super A, ? super A> deductFn) {
            this.deductFn = deductFn;
            return this;
        }

        @Nonnull
        public <R> AggregateOperation3<T0, T1, T2, A, R> andFinish(@Nonnull DistributedFunction<? super A, R> finishFn) {
            return new AggregateOperation3Impl<T0, T1, T2, A, R>(this.createFn, this.accumulateFn0, this.accumulateFn1, this.accumulateFn2, this.combineFn, this.deductFn, finishFn);
        }

        @Nonnull
        public AggregateOperation3<T0, T1, T2, A, A> andIdentityFinish() {
            return new AggregateOperation3Impl(this.createFn, this.accumulateFn0, this.accumulateFn1, this.accumulateFn2, this.combineFn, this.deductFn, DistributedFunction.identity());
        }
    }

    public static class Arity2<T0, T1, A> {
        @Nonnull
        private final DistributedSupplier<A> createFn;
        @Nonnull
        private final DistributedBiConsumer<? super A, T0> accumulateFn0;
        @Nonnull
        private final DistributedBiConsumer<? super A, T1> accumulateFn1;
        private DistributedBiConsumer<? super A, ? super A> combineFn;
        private DistributedBiConsumer<? super A, ? super A> deductFn;

        Arity2(@Nonnull Arity1<T0, A> step1, @Nonnull DistributedBiConsumer<? super A, T1> accumulateFn1) {
            this.createFn = ((Arity1)step1).createFn;
            this.accumulateFn0 = ((Arity1)step1).accumulateFn0;
            this.accumulateFn1 = accumulateFn1;
        }

        @Nonnull
        public <T2> Arity3<T0, T1, T2, A> andAccumulate2(@Nonnull DistributedBiConsumer<? super A, T2> accumulateFn2) {
            return new Arity3(this, accumulateFn2);
        }

        @Nonnull
        public Arity2<T0, T1, A> andCombine(DistributedBiConsumer<? super A, ? super A> combineFn) {
            this.combineFn = combineFn;
            return this;
        }

        @Nonnull
        public Arity2<T0, T1, A> andDeduct(DistributedBiConsumer<? super A, ? super A> deductFn) {
            this.deductFn = deductFn;
            return this;
        }

        @Nonnull
        public <R> AggregateOperation2<T0, T1, A, R> andFinish(@Nonnull DistributedFunction<? super A, R> finishFn) {
            return new AggregateOperation2Impl<T0, T1, A, R>(this.createFn, this.accumulateFn0, this.accumulateFn1, this.combineFn, this.deductFn, finishFn);
        }

        @Nonnull
        public AggregateOperation2<T0, T1, A, A> andIdentityFinish() {
            return new AggregateOperation2Impl(this.createFn, this.accumulateFn0, this.accumulateFn1, this.combineFn, this.deductFn, DistributedFunction.identity());
        }
    }

    public static class Arity1<T0, A> {
        @Nonnull
        private final DistributedSupplier<A> createFn;
        @Nonnull
        private final DistributedBiConsumer<? super A, T0> accumulateFn0;
        private DistributedBiConsumer<? super A, ? super A> combineFn;
        private DistributedBiConsumer<? super A, ? super A> deductFn;

        Arity1(@Nonnull DistributedSupplier<A> createFn, @Nonnull DistributedBiConsumer<? super A, T0> accumulateFn0) {
            this.createFn = createFn;
            this.accumulateFn0 = accumulateFn0;
        }

        @Nonnull
        public <T1> Arity2<T0, T1, A> andAccumulate1(@Nonnull DistributedBiConsumer<? super A, T1> accumulateFn1) {
            return new Arity2(this, accumulateFn1);
        }

        @Nonnull
        public Arity1<T0, A> andCombine(DistributedBiConsumer<? super A, ? super A> combineFn) {
            this.combineFn = combineFn;
            return this;
        }

        @Nonnull
        public Arity1<T0, A> andDeduct(DistributedBiConsumer<? super A, ? super A> deductFn) {
            this.deductFn = deductFn;
            return this;
        }

        @Nonnull
        public <R> AggregateOperation1<T0, A, R> andFinish(@Nonnull DistributedFunction<? super A, R> finishFn) {
            return new AggregateOperation1Impl<T0, A, R>(this.createFn, this.accumulateFn0, this.combineFn, this.deductFn, finishFn);
        }

        @Nonnull
        public AggregateOperation1<T0, A, A> andIdentityFinish() {
            return new AggregateOperation1Impl(this.createFn, this.accumulateFn0, this.combineFn, this.deductFn, DistributedFunction.identity());
        }
    }
}

