/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.aggregate;

import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperationBuilder;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.aggregate.AggregateOperation1Impl;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface AggregateOperation<A, R>
extends Serializable {
    @Nonnull
    public DistributedSupplier<A> createFn();

    @Nonnull
    default public <T> DistributedBiConsumer<? super A, ? super T> accumulateFn(@Nonnull Tag<T> tag) {
        return this.accumulateFn(tag.index());
    }

    @Nonnull
    public <T> DistributedBiConsumer<? super A, ? super T> accumulateFn(int var1);

    @Nullable
    public DistributedBiConsumer<? super A, ? super A> combineFn();

    @Nullable
    public DistributedBiConsumer<? super A, ? super A> deductFn();

    @Nonnull
    public DistributedFunction<? super A, R> finishFn();

    @Nonnull
    public <R_NEW> AggregateOperation<A, R_NEW> withFinishFn(@Nonnull DistributedFunction<? super A, R_NEW> var1);

    @Nonnull
    default public <T> AggregateOperation1<T, A, R> withCombiningAccumulateFn(@Nonnull DistributedFunction<T, A> getAccFn) {
        DistributedBiConsumer combineFn = this.combineFn();
        Objects.requireNonNull(combineFn, "The 'combine' primitive is missing");
        return new AggregateOperation1Impl(this.createFn(), (acc, item) -> combineFn.accept(acc, getAccFn.apply(item)), combineFn, this.deductFn(), this.finishFn());
    }

    @Nonnull
    public static <A> AggregateOperationBuilder<A> withCreate(@Nonnull DistributedSupplier<A> createFn) {
        return new AggregateOperationBuilder<A>(createFn);
    }
}

