/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.cache.journal.EventJournalCacheEvent;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.jet.Source;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.impl.SourceImpl;
import com.hazelcast.map.journal.EventJournalMapEvent;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Sources {
    private static final String GLOB_WILDCARD = "*";

    private Sources() {
    }

    public static <T> Source<T> fromProcessor(@Nonnull String sourceName, @Nonnull ProcessorMetaSupplier metaSupplier) {
        return new SourceImpl(sourceName, metaSupplier);
    }

    public static <K, V> Source<Map.Entry<K, V>> map(@Nonnull String mapName) {
        return Sources.fromProcessor("map(" + mapName + ')', SourceProcessors.readMapP(mapName));
    }

    public static <K, V, T> Source<T> map(@Nonnull String mapName, @Nonnull Predicate<K, V> predicate, @Nonnull Projection<Map.Entry<K, V>, T> projection) {
        return Sources.fromProcessor("map(" + mapName + ')', SourceProcessors.readMapP(mapName, predicate, projection));
    }

    public static <K, V, T> Source<T> map(@Nonnull String mapName, @Nonnull Predicate<K, V> predicate, @Nonnull DistributedFunction<Map.Entry<K, V>, T> projectionFn) {
        return Sources.fromProcessor("map(" + mapName + ')', SourceProcessors.readMapP(mapName, predicate, projectionFn));
    }

    @Nonnull
    public static <K, V, T> Source<T> mapJournal(@Nonnull String mapName, @Nullable DistributedPredicate<EventJournalMapEvent<K, V>> predicateFn, @Nullable DistributedFunction<EventJournalMapEvent<K, V>, T> projectionFn, boolean startFromLatestSequence) {
        return Sources.fromProcessor("mapJournal(" + mapName + ')', SourceProcessors.streamMapP(mapName, predicateFn, projectionFn, startFromLatestSequence));
    }

    @Nonnull
    public static <K, V> Source<EventJournalMapEvent<K, V>> mapJournal(@Nonnull String mapName, boolean startFromLatestSequence) {
        return Sources.fromProcessor("mapJournal(" + mapName + ')', SourceProcessors.streamMapP(mapName, startFromLatestSequence));
    }

    @Nonnull
    public static <K, V> Source<Map.Entry<K, V>> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return Sources.fromProcessor("remoteMap(" + mapName + ')', SourceProcessors.readRemoteMapP(mapName, clientConfig));
    }

    public static <K, V, T> Source<T> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<K, V> predicate, @Nonnull Projection<Map.Entry<K, V>, T> projection) {
        return Sources.fromProcessor("remoteMap(" + mapName + ')', SourceProcessors.readRemoteMapP(mapName, clientConfig, predicate, projection));
    }

    public static <K, V, T> Source<T> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<K, V> predicate, @Nonnull DistributedFunction<Map.Entry<K, V>, T> projectionFn) {
        return Sources.fromProcessor("remoteMap(" + mapName + ')', SourceProcessors.readRemoteMapP(mapName, clientConfig, predicate, projectionFn));
    }

    @Nonnull
    public static <K, V, T> Source<T> remoteMapJournal(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nullable DistributedPredicate<EventJournalMapEvent<K, V>> predicateFn, @Nullable DistributedFunction<EventJournalMapEvent<K, V>, T> projectionFn, boolean startFromLatestSequence) {
        return Sources.fromProcessor("remoteMapJournal(" + mapName + ')', SourceProcessors.streamRemoteMapP(mapName, clientConfig, predicateFn, projectionFn, startFromLatestSequence));
    }

    @Nonnull
    public static <K, V> Source<EventJournalMapEvent<K, V>> remoteMapJournal(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, boolean startFromLatestSequence) {
        return Sources.fromProcessor("remoteMapJournal(" + mapName + ')', SourceProcessors.streamRemoteMapP(mapName, clientConfig, startFromLatestSequence));
    }

    @Nonnull
    public static <K, V> Source<Map.Entry<K, V>> cache(@Nonnull String cacheName) {
        return Sources.fromProcessor("cache(" + cacheName + ')', SourceProcessors.readCacheP(cacheName));
    }

    @Nonnull
    public static <K, V, T> Source<T> cacheJournal(@Nonnull String cacheName, @Nullable DistributedPredicate<EventJournalCacheEvent<K, V>> predicateFn, @Nullable DistributedFunction<EventJournalCacheEvent<K, V>, T> projectionFn, boolean startFromLatestSequence) {
        return Sources.fromProcessor("cacheJournal(" + cacheName + ')', SourceProcessors.streamCacheP(cacheName, predicateFn, projectionFn, startFromLatestSequence));
    }

    @Nonnull
    public static <K, V> Source<EventJournalCacheEvent<K, V>> cacheJournal(@Nonnull String cacheName, boolean startFromLatestSequence) {
        return Sources.fromProcessor("cacheJournal(" + cacheName + ')', SourceProcessors.streamCacheP(cacheName, startFromLatestSequence));
    }

    @Nonnull
    public static <K, V> Source<Map.Entry<K, V>> remoteCache(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return Sources.fromProcessor("remoteCache(" + cacheName + ')', SourceProcessors.readRemoteCacheP(cacheName, clientConfig));
    }

    @Nonnull
    public static <K, V, T> Source<T> remoteCacheJournal(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig, @Nullable DistributedPredicate<EventJournalCacheEvent<K, V>> predicateFn, @Nullable DistributedFunction<EventJournalCacheEvent<K, V>, T> projectionFn, boolean startFromLatestSequence) {
        return Sources.fromProcessor("remoteCacheJournal(" + cacheName + ')', SourceProcessors.streamRemoteCacheP(cacheName, clientConfig, predicateFn, projectionFn, startFromLatestSequence));
    }

    @Nonnull
    public static <K, V> Source<EventJournalCacheEvent<K, V>> remoteCacheJournal(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig, boolean startFromLatestSequence) {
        return Sources.fromProcessor("remoteCacheJournal(" + cacheName + ')', SourceProcessors.streamRemoteCacheP(cacheName, clientConfig, startFromLatestSequence));
    }

    @Nonnull
    public static <E> Source<E> list(@Nonnull String listName) {
        return Sources.fromProcessor("list(" + listName + ')', SourceProcessors.readListP(listName));
    }

    @Nonnull
    public static <E> Source<E> remoteList(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return Sources.fromProcessor("remoteList(" + listName + ')', SourceProcessors.readRemoteListP(listName, clientConfig));
    }

    @Nonnull
    public static Source<String> socket(@Nonnull String host, int port, @Nonnull Charset charset) {
        return Sources.fromProcessor("socket(" + host + ':' + port + ')', SourceProcessors.streamSocketP(host, port, charset));
    }

    @Nonnull
    public static Source<String> files(@Nonnull String directory, @Nonnull Charset charset, @Nonnull String glob) {
        return Sources.fromProcessor("files(" + directory + '/' + glob + ')', SourceProcessors.readFilesP(directory, charset, glob));
    }

    public static Source<String> files(@Nonnull String directory) {
        return Sources.files(directory, StandardCharsets.UTF_8, GLOB_WILDCARD);
    }

    public static Source<String> fileWatcher(@Nonnull String watchedDirectory, @Nonnull Charset charset, @Nonnull String glob) {
        return Sources.fromProcessor("fileWatcher(" + watchedDirectory + '/' + glob + ')', SourceProcessors.streamFilesP(watchedDirectory, charset, glob));
    }

    public static Source<String> fileWatcher(@Nonnull String watchedDirectory) {
        return Sources.fileWatcher(watchedDirectory, StandardCharsets.UTF_8, GLOB_WILDCARD);
    }
}

