/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.jet.Sink;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.processor.DiagnosticProcessors;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.impl.SinkImpl;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;

public final class Sinks {
    private Sinks() {
    }

    public static <E> Sink<E> fromProcessor(String sinkName, ProcessorMetaSupplier metaSupplier) {
        return new SinkImpl(sinkName, metaSupplier);
    }

    public static <E extends Map.Entry> Sink<E> map(String mapName) {
        return Sinks.fromProcessor("map(" + mapName + ')', SinkProcessors.writeMapP(mapName));
    }

    public static <E extends Map.Entry> Sink<E> remoteMap(String mapName, ClientConfig clientConfig) {
        return Sinks.fromProcessor("remoteMap(" + mapName + ')', SinkProcessors.writeRemoteMapP(mapName, clientConfig));
    }

    public static <E extends Map.Entry> Sink<E> cache(String cacheName) {
        return Sinks.fromProcessor("cache(" + cacheName + ')', SinkProcessors.writeCacheP(cacheName));
    }

    public static <E extends Map.Entry> Sink<E> remoteCache(String cacheName, ClientConfig clientConfig) {
        return Sinks.fromProcessor("remoteCache(" + cacheName + ')', SinkProcessors.writeRemoteCacheP(cacheName, clientConfig));
    }

    public static <E> Sink<E> list(String listName) {
        return Sinks.fromProcessor("list(" + listName + ')', SinkProcessors.writeListP(listName));
    }

    public static <E> Sink<E> remoteList(String listName, ClientConfig clientConfig) {
        return Sinks.fromProcessor("remoteList(" + listName + ')', SinkProcessors.writeRemoteListP(listName, clientConfig));
    }

    public static <E> Sink<E> socket(@Nonnull String host, int port, @Nonnull DistributedFunction<E, String> toStringFn, @Nonnull Charset charset) {
        return Sinks.fromProcessor("socket(" + host + ':' + port + ')', SinkProcessors.writeSocketP(host, port, toStringFn, charset));
    }

    public static <E> Sink<E> socket(@Nonnull String host, int port, @Nonnull DistributedFunction<E, String> toStringFn) {
        return Sinks.fromProcessor("socket(" + host + ':' + port + ')', SinkProcessors.writeSocketP(host, port, toStringFn, StandardCharsets.UTF_8));
    }

    public static <E> Sink<E> socket(@Nonnull String host, int port) {
        return Sinks.fromProcessor("socket(" + host + ':' + port + ')', SinkProcessors.writeSocketP(host, port, Object::toString, StandardCharsets.UTF_8));
    }

    @Nonnull
    public static <E> Sink<E> files(@Nonnull String directoryName, @Nonnull DistributedFunction<E, String> toStringFn, @Nonnull Charset charset, boolean append) {
        return Sinks.fromProcessor("files(" + directoryName + ')', SinkProcessors.writeFileP(directoryName, toStringFn, charset, append));
    }

    @Nonnull
    public static <E> Sink<E> files(@Nonnull String directoryName, @Nonnull DistributedFunction<E, String> toStringFn) {
        return Sinks.files(directoryName, toStringFn, StandardCharsets.UTF_8, false);
    }

    @Nonnull
    public static <E> Sink<E> files(@Nonnull String directoryName) {
        return Sinks.files(directoryName, Object::toString, StandardCharsets.UTF_8, false);
    }

    @Nonnull
    public static <E> Sink<E> logger(DistributedFunction<E, String> toStringFn) {
        return Sinks.fromProcessor("logger", DiagnosticProcessors.writeLoggerP(toStringFn));
    }

    @Nonnull
    public static <E> Sink<E> logger() {
        return Sinks.logger(Object::toString);
    }
}

