/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.function.DistributedFunction;
import java.io.Serializable;
import java.util.Map;

public final class JoinClause<K, E0, E1, E1_OUT>
implements Serializable {
    private final DistributedFunction<E0, K> leftKeyFn;
    private final DistributedFunction<E1, K> rightKeyFn;
    private final DistributedFunction<E1, E1_OUT> rightProjectFn;

    private JoinClause(DistributedFunction<E0, K> leftKeyFn, DistributedFunction<E1, K> rightKeyFn, DistributedFunction<E1, E1_OUT> rightProjectFn) {
        this.leftKeyFn = leftKeyFn;
        this.rightKeyFn = rightKeyFn;
        this.rightProjectFn = rightProjectFn;
    }

    public static <K, E0, E1> JoinClause<K, E0, E1, E1> onKeys(DistributedFunction<E0, K> leftKeyFn, DistributedFunction<E1, K> rightKeyFn) {
        return new JoinClause(leftKeyFn, rightKeyFn, DistributedFunction.identity());
    }

    public static <K, E0, E1_IN extends Map.Entry<K, E1>, E1> JoinClause<K, E0, E1_IN, E1> joinMapEntries(DistributedFunction<E0, K> leftKeyFn) {
        return new JoinClause(leftKeyFn, Map.Entry::getKey, Map.Entry::getValue);
    }

    public <E1_NEW_OUT> JoinClause<K, E0, E1, E1_NEW_OUT> projecting(DistributedFunction<E1, E1_NEW_OUT> rightProjectFn) {
        return new JoinClause<K, E0, E1, E1_NEW_OUT>(this.leftKeyFn, this.rightKeyFn, rightProjectFn);
    }

    public DistributedFunction<E0, K> leftKeyFn() {
        return this.leftKeyFn;
    }

    public DistributedFunction<E1, K> rightKeyFn() {
        return this.rightKeyFn;
    }

    public DistributedFunction<E1, E1_OUT> rightProjectFn() {
        return this.rightProjectFn;
    }
}

