/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.ComputeStage;
import com.hazelcast.jet.JoinClause;
import com.hazelcast.jet.datamodel.ItemsByTag;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.impl.PipelineImpl;
import com.hazelcast.jet.impl.transform.HashJoinTransform;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HashJoinBuilder<E0> {
    private final Map<Tag<?>, StageAndClause> clauses = new HashMap();

    HashJoinBuilder(ComputeStage<E0> stage0) {
        this.add(stage0, null);
    }

    public <K, E1_IN, E1> Tag<E1> add(ComputeStage<E1_IN> stage, JoinClause<K, E0, E1_IN, E1> joinClause) {
        Tag tag = Tag.tag(this.clauses.size());
        this.clauses.put(tag, new StageAndClause<K, E0, E1_IN, E1>(stage, joinClause));
        return tag;
    }

    public ComputeStage<Tuple2<E0, ItemsByTag>> build() {
        List orderedClauses = this.clauses.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList());
        List<ComputeStage> upstream = orderedClauses.stream().map(e -> ((StageAndClause)e.getValue()).stage()).collect(Collectors.toList());
        Stream<JoinClause> joinClauses = orderedClauses.stream().skip(1L).map(e -> ((StageAndClause)e.getValue()).clause());
        HashJoinTransform hashJoinTransform = new HashJoinTransform(joinClauses.collect(Collectors.toList()), orderedClauses.stream().skip(1L).map(Map.Entry::getKey).collect(Collectors.toList()));
        PipelineImpl pipeline = (PipelineImpl)this.clauses.get(Tag.tag0()).stage().getPipeline();
        return pipeline.attach(upstream, hashJoinTransform);
    }

    private static class StageAndClause<K, E0, E1, E1_OUT> {
        private final ComputeStage<E1> stage;
        private final JoinClause<K, E0, E1, E1_OUT> joinClause;

        StageAndClause(ComputeStage<E1> stage, JoinClause<K, E0, E1, E1_OUT> joinClause) {
            this.stage = stage;
            this.joinClause = joinClause;
        }

        ComputeStage<E1> stage() {
            return this.stage;
        }

        JoinClause<K, E0, E1, E1_OUT> clause() {
            return this.joinClause;
        }
    }
}

