/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.collectors;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.collectors.AbstractCollector;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;

public abstract class AbstractHazelcastCollector<T, R>
extends AbstractCollector<T, Object, R> {
    @Override
    public R collect(StreamContext context, Pipeline<? extends T> upstream) {
        R target = this.getTarget(context.getJetInstance());
        DAG dag = new DAG();
        Vertex vertex = upstream.buildDAG(dag);
        Vertex writer = dag.newVertex(StreamUtil.writerVertexName(this.getName()), this.getConsumer());
        if (this.localParallelism() > 0) {
            writer.localParallelism(this.localParallelism());
        }
        dag.edge(Edge.between(vertex, writer));
        StreamUtil.executeJob(context, dag);
        return target;
    }

    protected abstract R getTarget(JetInstance var1);

    protected abstract ProcessorMetaSupplier getConsumer();

    protected abstract int localParallelism();

    protected abstract String getName();
}

