/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.jet.impl.deployment.ClassLoaderEntry;
import com.hazelcast.jet.impl.deployment.ResourceStore;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.util.EmptyStatement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class JetClassLoader
extends ClassLoader {
    private final Map<String, Class> classes = new HashMap<String, Class>();
    private ResourceStore store;

    public JetClassLoader(ResourceStore store) {
        this.store = store;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        if (this.isEmpty(className)) {
            return null;
        }
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            Class cached = this.classes.get(className);
            if (cached != null) {
                return cached;
            }
            try {
                return this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException ignored) {
                int lastDotIndex;
                EmptyStatement.ignore((Throwable)ignored);
                byte[] classBytes = this.classBytes(className);
                if (classBytes == null) {
                    throw new ClassNotFoundException(className);
                }
                Class<?> defined = this.defineClass(className, classBytes, 0, classBytes.length);
                if (defined == null) {
                    throw new ClassNotFoundException(className);
                }
                if (defined.getPackage() == null && (lastDotIndex = className.lastIndexOf(46)) >= 0) {
                    String name = className.substring(0, lastDotIndex);
                    this.definePackage(name, null, null, null, null, null, null, null);
                }
                if (resolveIt) {
                    this.resolveClass(defined);
                }
                this.classes.put(className, defined);
                return defined;
            }
        }
    }

    @Override
    public URL getResource(String name) {
        if (this.isEmpty(name)) {
            return null;
        }
        URL url = this.getResourceURL(name);
        if (url == null) {
            return null;
        }
        return url;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        ClassLoaderEntry classLoaderEntry;
        if (this.isEmpty(name)) {
            return null;
        }
        byte[] arr = this.classBytes(name);
        if (arr == null && (classLoaderEntry = this.store.getDataEntries().get(name)) != null) {
            arr = classLoaderEntry.getResourceBytes();
        }
        if (arr == null) {
            return null;
        }
        return new ByteArrayInputStream(arr);
    }

    private byte[] classBytes(String name) {
        ClassLoaderEntry entry = this.coalesce(name, this.store.getClassEntries(), this.store.getJarEntries());
        if (entry == null) {
            return null;
        }
        return entry.getResourceBytes();
    }

    @SafeVarargs
    private final ClassLoaderEntry coalesce(String name, Map<String, ClassLoaderEntry> ... resources) {
        for (Map<String, ClassLoaderEntry> map : resources) {
            ClassLoaderEntry entry = map.get(name);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    private URL getResourceURL(String name) {
        ClassLoaderEntry entry = this.coalesce(name, this.store.getClassEntries(), this.store.getDataEntries(), this.store.getJarEntries());
        if (entry == null) {
            return null;
        }
        if (entry.getBaseUrl() == null) {
            throw new IllegalArgumentException("non-URL accessible resource");
        }
        try {
            return new URL(entry.getBaseUrl());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private boolean isEmpty(String className) {
        return className == null || className.isEmpty();
    }
}

