/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.jet.Inbox;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.SerializableClientConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class WriteIListP
implements Processor {
    private final List list;
    private final ArrayList<Object> buffer = new ArrayList();

    WriteIListP(List list) {
        this.list = list;
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        inbox.drainTo(this.buffer);
        this.list.addAll(this.buffer);
        this.buffer.clear();
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    public static ProcessorSupplier supplier(String listName) {
        return new Supplier(listName);
    }

    public static ProcessorSupplier supplier(String listName, ClientConfig clientConfig) {
        return new Supplier(listName, clientConfig);
    }

    private static class Supplier
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final String name;
        private final SerializableClientConfig clientConfig;
        private transient IList list;
        private transient HazelcastInstance client;

        Supplier(String name) {
            this(name, null);
        }

        Supplier(String name, ClientConfig clientConfig) {
            this.name = name;
            this.clientConfig = clientConfig != null ? new SerializableClientConfig(clientConfig) : null;
        }

        private boolean isRemote() {
            return this.clientConfig != null;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            HazelcastInstance instance = this.isRemote() ? (this.client = HazelcastClient.newHazelcastClient((ClientConfig)this.clientConfig.asClientConfig())) : context.jetInstance().getHazelcastInstance();
            this.list = instance.getList(this.name);
        }

        @Override
        public void complete(Throwable error) {
            if (this.client != null) {
                this.client.shutdown();
            }
        }

        @Nonnull
        public List<Processor> get(int count) {
            return Stream.generate(() -> new WriteIListP((List)this.list)).limit(count).collect(Collectors.toList());
        }
    }
}

