/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.jet.AbstractProcessor;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.impl.util.Util;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ReadSocketTextStreamP
extends AbstractProcessor
implements Closeable {
    private final String host;
    private final int port;
    private BufferedReader bufferedReader;
    private Socket socket;

    ReadSocketTextStreamP(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) throws Exception {
        this.getLogger().info("Connecting to socket " + this.hostAndPort());
        this.socket = new Socket(this.host, this.port);
        this.getLogger().info("Connected to socket " + this.hostAndPort());
        this.bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
    }

    @Override
    public boolean complete() {
        return Util.uncheckCall(this::tryComplete);
    }

    private boolean tryComplete() throws IOException {
        String inputLine;
        while ((inputLine = this.bufferedReader.readLine()) != null) {
            this.emit(inputLine);
            if (!this.getOutbox().isHighWater()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.bufferedReader != null) {
            this.getLogger().info("Closing socket " + this.hostAndPort());
            this.bufferedReader.close();
        }
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    public static ProcessorSupplier supplier(String host, int port) {
        return new Supplier(host, port);
    }

    private String hostAndPort() {
        return this.host + ':' + this.port;
    }

    private static void assertCountIsOne(int count) {
        if (count != 1) {
            throw new IllegalArgumentException("count != 1");
        }
    }

    private static class Supplier
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final String host;
        private final int port;
        private transient ReadSocketTextStreamP reader;

        Supplier(String host, int port) {
            this.host = host;
            this.port = port;
        }

        @Nonnull
        public List<Processor> get(int count) {
            ReadSocketTextStreamP.assertCountIsOne(count);
            this.reader = new ReadSocketTextStreamP(this.host, this.port);
            return Collections.singletonList(this.reader);
        }

        @Override
        public void complete(Throwable error) {
            Util.uncheckRun(this.reader::close);
        }
    }
}

