/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.impl.SerializationConstants;
import com.hazelcast.jet.impl.deployment.ResourcePart;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;

final class JetDataSerializerHook
implements DataSerializerHook {
    JetDataSerializerHook() {
    }

    public int getFactoryId() {
        return SerializationConstants.FACTORY_ID;
    }

    public DataSerializableFactory createFactory() {
        return new Factory();
    }

    private static class Factory
    implements DataSerializableFactory {
        private Factory() {
        }

        public IdentifiedDataSerializable create(int typeId) {
            switch (typeId) {
                case 0: {
                    return new DAG();
                }
                case 2: {
                    return new Edge();
                }
                case 1: {
                    return new Vertex();
                }
                case 3: {
                    return new ResourcePart();
                }
            }
            throw new IllegalArgumentException("Unknown type id " + typeId);
        }
    }
}

