/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.reducers;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.reducers.CollectorReducer;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class BiConsumerCombinerReducer<T, R>
implements DistributedCollector.Reducer<T, R> {
    private final Supplier<R> supplier;
    private final BiConsumer<R, ? super T> accumulator;
    private final BiConsumer<R, R> combiner;

    public BiConsumerCombinerReducer(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        this.supplier = supplier;
        this.accumulator = accumulator;
        this.combiner = combiner;
    }

    @Override
    public R reduce(StreamContext context, Pipeline<? extends T> upstream) {
        DAG dag = new DAG();
        Vertex accumulatorVertex = CollectorReducer.buildAccumulator(dag, upstream, this.supplier, this.accumulator);
        Vertex combinerVertex = CollectorReducer.buildCombiner(dag, accumulatorVertex, this.combiner, null);
        return CollectorReducer.execute(context, dag, combinerVertex);
    }
}

