/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.reducers;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;

abstract class AbstractSinkReducer<T, R>
implements DistributedCollector.Reducer<T, R> {
    AbstractSinkReducer() {
    }

    @Override
    public R reduce(StreamContext context, Pipeline<? extends T> upstream) {
        R target = this.getTarget(context.getJetInstance());
        DAG dag = new DAG();
        Vertex vertex = upstream.buildDAG(dag);
        Vertex writer = dag.newVertex("write-" + this.getName(), this.getSupplier());
        if (this.localParallelism() > 0) {
            writer.localParallelism(this.localParallelism());
        }
        dag.edge(Edge.between(vertex, writer));
        StreamUtil.executeJob(context, dag);
        return target;
    }

    protected abstract R getTarget(JetInstance var1);

    protected abstract ProcessorMetaSupplier getSupplier();

    protected abstract int localParallelism();

    protected abstract String getName();
}

