/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.core.Member;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class Util {
    public static final int BUFFER_SIZE = 32768;

    private Util() {
    }

    public static <T> T uncheckedGet(@Nonnull Future<T> f) {
        try {
            return f.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public static <T> T uncheckCall(@Nonnull Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static void uncheckRun(@Nonnull RunnableExc r) {
        try {
            r.run();
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    @Nonnull
    public static List<Address> getRemoteMembers(@Nonnull NodeEngine engine) {
        Member localMember = engine.getLocalMember();
        return engine.getClusterService().getMembers().stream().filter(m -> !m.equals(localMember)).map(Member::getAddress).collect(Collectors.toList());
    }

    public static Connection getMemberConnection(@Nonnull NodeEngine engine, @Nonnull Address memberAddr) {
        return ((NodeEngineImpl)engine).getNode().getConnectionManager().getConnection(memberAddr);
    }

    @Nonnull
    public static BufferObjectDataOutput createObjectDataOutput(@Nonnull NodeEngine engine) {
        return ((InternalSerializationService)engine.getSerializationService()).createObjectDataOutput(32768);
    }

    @Nonnull
    public static BufferObjectDataInput createObjectDataInput(@Nonnull NodeEngine engine, @Nonnull byte[] buf) {
        return ((InternalSerializationService)engine.getSerializationService()).createObjectDataInput(buf);
    }

    @Nonnull
    public static byte[] read(@Nonnull InputStream in, int count) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] b = new byte[count];
            out.write(b, 0, in.read(b));
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    @Nonnull
    public static byte[] read(@Nonnull InputStream in) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int len;
            byte[] b = new byte[32768];
            while ((len = in.read(b)) != -1) {
                out.write(b, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static void writeList(@Nonnull ObjectDataOutput output, @Nonnull List list) throws IOException {
        output.writeInt(list.size());
        for (Object o : list) {
            output.writeObject(o);
        }
    }

    @Nonnull
    public static <E> List<E> readList(@Nonnull ObjectDataInput output) throws IOException {
        int length = output.readInt();
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            list.add(output.readObject());
        }
        return list;
    }

    public static interface RunnableExc {
        public void run() throws Exception;
    }
}

