/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.internal.util.concurrent.ConcurrentConveyor;
import com.hazelcast.jet.impl.execution.OutboundCollector;
import com.hazelcast.jet.impl.util.ProgressState;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class ConveyorCollector
implements OutboundCollector {
    protected final Object doneItem;
    private final ConcurrentConveyor<Object> conveyor;
    private final int queueIndex;
    private final int[] partitions;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public ConveyorCollector(ConcurrentConveyor<Object> conveyor, int queueIndex, int[] partitions) {
        this.conveyor = conveyor;
        this.queueIndex = queueIndex;
        this.partitions = partitions;
        this.doneItem = conveyor.submitterGoneItem();
    }

    @Override
    public ProgressState offer(Object item) {
        return this.conveyor.offer(this.queueIndex, item) ? ProgressState.DONE : ProgressState.NO_PROGRESS;
    }

    @Override
    public ProgressState close() {
        return this.offer(this.doneItem);
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public int[] getPartitions() {
        return this.partitions;
    }
}

