/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.impl.execution.InboundEdgeStream;
import com.hazelcast.jet.impl.execution.InboundEmitter;
import com.hazelcast.jet.impl.util.ProgressState;
import com.hazelcast.jet.impl.util.ProgressTracker;
import java.util.Collection;

public class ConcurrentInboundEdgeStream
implements InboundEdgeStream {
    private final int ordinal;
    private final int priority;
    private final InboundEmitter[] producers;
    private final ProgressTracker tracker;

    public ConcurrentInboundEdgeStream(InboundEmitter[] producers, int ordinal, int priority) {
        this.producers = (InboundEmitter[])producers.clone();
        this.ordinal = ordinal;
        this.priority = priority;
        this.tracker = new ProgressTracker();
    }

    @Override
    public ProgressState drainTo(Collection<Object> dest) {
        this.tracker.reset();
        for (int i = 0; i < this.producers.length; ++i) {
            InboundEmitter producer = this.producers[i];
            if (producer == null) continue;
            ProgressState result = producer.drainTo(dest);
            if (result.isDone()) {
                this.producers[i] = null;
            }
            this.tracker.mergeWith(result);
        }
        return this.tracker.toProgressState();
    }

    @Override
    public int ordinal() {
        return this.ordinal;
    }

    @Override
    public int priority() {
        return this.priority;
    }
}

