/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.impl.execution.ExecutionContext;
import com.hazelcast.jet.impl.execution.SenderTasklet;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Networking {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final ScheduledFuture<?> flowControlSender;
    private final ConcurrentHashMap<Long, ExecutionContext> executionContexts;

    Networking(NodeEngine nodeEngine, ConcurrentHashMap<Long, ExecutionContext> executionContexts, int flowControlPeriodMs) {
        this.nodeEngine = (NodeEngineImpl)nodeEngine;
        this.executionContexts = executionContexts;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.flowControlSender = nodeEngine.getExecutionService().scheduleWithRepetition(this::broadcastFlowControlPacket, 0L, (long)flowControlPeriodMs, TimeUnit.MILLISECONDS);
    }

    void destroy() {
        this.flowControlSender.cancel(false);
    }

    void handle(Packet packet) throws IOException {
        if (!packet.isFlagRaised(2)) {
            this.handleStreamPacket(packet);
            return;
        }
        this.handleFlowControlPacket(packet.getConn().getEndPoint(), packet.toByteArray());
    }

    private void handleStreamPacket(Packet packet) throws IOException {
        BufferObjectDataInput in = Util.createObjectDataInput((NodeEngine)this.nodeEngine, packet.toByteArray());
        long executionId = in.readLong();
        int vertexId = in.readInt();
        int ordinal = in.readInt();
        this.executionContexts.get(executionId).handlePacket(vertexId, ordinal, packet.getConn().getEndPoint(), in);
    }

    public static byte[] createStreamPacketHeader(NodeEngine nodeEngine, long executionId, int destinationVertexId, int ordinal) {
        BufferObjectDataOutput out = Util.createObjectDataOutput(nodeEngine);
        try {
            out.writeLong(executionId);
            out.writeInt(destinationVertexId);
            out.writeInt(ordinal);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    private void broadcastFlowControlPacket() {
        try {
            Util.getRemoteMembers((NodeEngine)this.nodeEngine).forEach(member -> Util.uncheckRun(() -> {
                byte[] packetBuf = this.createFlowControlPacket((Address)member);
                if (packetBuf.length == 0) {
                    return;
                }
                Connection conn = Util.getMemberConnection((NodeEngine)this.nodeEngine, member);
                conn.write((OutboundFrame)new Packet(packetBuf).setPacketType(Packet.Type.JET).raiseFlags(18));
            }));
        }
        catch (Throwable t) {
            this.logger.severe("Flow-control packet broadcast failed", t);
        }
    }

    private byte[] createFlowControlPacket(Address member) throws IOException {
        BufferObjectDataOutput out = Util.createObjectDataOutput((NodeEngine)this.nodeEngine);
        boolean[] hasData = new boolean[]{false};
        out.writeInt(this.executionContexts.size());
        this.executionContexts.forEach((arg_0, arg_1) -> Networking.lambda$createFlowControlPacket$6(member, (ObjectDataOutput)out, hasData, arg_0, arg_1));
        return hasData[0] ? out.toByteArray() : EMPTY_BYTES;
    }

    private void handleFlowControlPacket(Address fromAddr, byte[] packet) throws IOException {
        BufferObjectDataInput in = Util.createObjectDataInput((NodeEngine)this.nodeEngine, packet);
        int executionCtxCount = in.readInt();
        for (int j = 0; j < executionCtxCount; ++j) {
            long exeCtxId = in.readLong();
            Map senderMap = Optional.ofNullable(this.executionContexts).map(exeCtxs -> (ExecutionContext)exeCtxs.get(exeCtxId)).map(ExecutionContext::senderMap).orElse(null);
            if (senderMap == null) {
                this.logMissingExeCtx(exeCtxId);
                continue;
            }
            int flowCtlMsgCount = in.readInt();
            for (int k = 0; k < flowCtlMsgCount; ++k) {
                int destVertexId = in.readInt();
                int destOrdinal = in.readInt();
                int sendSeqLimitCompressed = in.readInt();
                SenderTasklet t = Optional.ofNullable(senderMap.get(destVertexId)).map(ordinalMap -> (Map)ordinalMap.get(destOrdinal)).map(addrMap -> (SenderTasklet)addrMap.get(fromAddr)).orElse(null);
                if (t == null) {
                    this.logMissingSenderTasklet(destVertexId, destOrdinal);
                    return;
                }
                t.setSendSeqLimitCompressed(sendSeqLimitCompressed);
            }
        }
    }

    private void logMissingExeCtx(long exeCtxId) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Ignoring flow control message applying to non-existent execution context " + exeCtxId);
        }
    }

    private void logMissingSenderTasklet(int destVertexId, int destOrdinal) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("Ignoring flow control message applying to non-existent sender tasklet (%d, %d)", destVertexId, destOrdinal));
        }
    }

    private static /* synthetic */ void lambda$createFlowControlPacket$6(Address member, ObjectDataOutput out, boolean[] hasData, Long execId, ExecutionContext exeCtx) {
        Util.uncheckRun(() -> {
            Integer memberId = exeCtx.getMemberId(member);
            if (memberId == null) {
                return;
            }
            out.writeLong(execId.longValue());
            out.writeInt(exeCtx.receiverMap().values().stream().mapToInt(Map::size).sum());
            exeCtx.receiverMap().forEach((vertexId, m) -> m.forEach((ordinal, tasklet) -> Util.uncheckRun(() -> {
                out.writeInt(vertexId.intValue());
                out.writeInt(ordinal.intValue());
                out.writeInt(tasklet.updateAndGetSendSeqLimitCompressed(memberId));
                hasData[0] = true;
            })));
        });
    }
}

