/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.stream.IStreamList;
import com.hazelcast.jet.stream.IStreamMap;
import com.hazelcast.jet.stream.impl.ListDecorator;
import com.hazelcast.jet.stream.impl.MapDecorator;

abstract class AbstractJetInstance
implements JetInstance {
    private static final String JET_ID_GENERATOR_NAME = "__jet_id_generator";
    private final HazelcastInstance hazelcastInstance;

    AbstractJetInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Override
    public Cluster getCluster() {
        return this.getHazelcastInstance().getCluster();
    }

    @Override
    public String getName() {
        return this.hazelcastInstance.getName();
    }

    @Override
    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    @Override
    public <K, V> IStreamMap<K, V> getMap(String name) {
        return new MapDecorator(this.hazelcastInstance.getMap(name), this);
    }

    @Override
    public <E> IStreamList<E> getList(String name) {
        return new ListDecorator(this.hazelcastInstance.getList(name), this);
    }

    @Override
    public void shutdown() {
        this.hazelcastInstance.shutdown();
    }

    protected IdGenerator getIdGenerator() {
        return this.hazelcastInstance.getIdGenerator(JET_ID_GENERATOR_NAME);
    }
}

