/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Traverser;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class Traversers {
    private Traversers() {
    }

    @Nonnull
    public static <T> Traverser<T> iterate(@Nonnull Iterator<T> iterator) {
        return () -> iterator.hasNext() ? iterator.next() : null;
    }

    @Nonnull
    public static <T> Traverser<T> spliterate(@Nonnull Spliterator<T> spliterator) {
        ResettableSingletonTraverser trav = new ResettableSingletonTraverser();
        return () -> {
            spliterator.tryAdvance(trav);
            return trav.next();
        };
    }

    @Nonnull
    public static <T> Traverser<T> enumerate(@Nonnull Enumeration<T> enumeration) {
        return () -> enumeration.hasMoreElements() ? enumeration.nextElement() : null;
    }

    @Nonnull
    public static <T> Traverser<T> traverseStream(@Nonnull Stream<T> stream) {
        return Traversers.spliterate(stream.spliterator());
    }

    @Nonnull
    public static <T> Traverser<T> traverseIterable(@Nonnull Iterable<T> iterable) {
        return Traversers.iterate(iterable.iterator());
    }

    @Nonnull
    public static <T> Traverser<T> traverseArray(@Nonnull T[] array) {
        return new ArrayTraverser<T>(array);
    }

    @Nonnull
    public static <T> Traverser<T> lazy(@Nonnull Supplier<Traverser<T>> supplierOfTraverser) {
        return new LazyTraverser<T>(supplierOfTraverser);
    }

    private static class ArrayTraverser<T>
    implements Traverser<T> {
        private int i;
        private final T[] array;

        ArrayTraverser(@Nonnull T[] array) {
            this.array = array;
        }

        @Override
        public T next() {
            return this.i < this.array.length && this.i >= 0 ? (T)this.array[this.i++] : null;
        }
    }

    private static final class LazyTraverser<T>
    implements Traverser<T> {
        private Supplier<Traverser<T>> supplierOfTraverser;
        private Traverser<T> traverser;

        LazyTraverser(@Nonnull Supplier<Traverser<T>> supplierOfTraverser) {
            this.supplierOfTraverser = supplierOfTraverser;
        }

        @Override
        public T next() {
            Traverser<T> trav = this.traverser;
            if (trav != null) {
                return trav.next();
            }
            try {
                this.traverser = this.supplierOfTraverser.get();
                T t = this.traverser.next();
                return t;
            }
            finally {
                this.supplierOfTraverser = null;
            }
        }
    }

    public static class ResettableSingletonTraverser<T>
    implements Traverser<T>,
    Consumer<T> {
        T item;

        @Override
        public T next() {
            try {
                T t = this.item;
                return t;
            }
            finally {
                this.item = null;
            }
        }

        @Override
        public void accept(T t) {
            this.item = t;
        }
    }
}

