/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.impl.util.FlatMappingTraverser;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface Traverser<T> {
    public T next();

    @Nonnull
    default public <R> Traverser<R> map(@Nonnull Function<? super T, ? extends R> mapper) {
        return () -> {
            T t = this.next();
            return t != null ? mapper.apply((T)t) : null;
        };
    }

    @Nonnull
    default public Traverser<T> filter(@Nonnull Predicate<? super T> pred) {
        return () -> {
            T t;
            while ((t = this.next()) != null) {
                if (!pred.test((T)t)) continue;
                return t;
            }
            return null;
        };
    }

    @Nonnull
    default public <R> Traverser<R> flatMap(@Nonnull Function<? super T, ? extends Traverser<? extends R>> mapper) {
        return new FlatMappingTraverser(this, mapper);
    }

    @SafeVarargs
    public static <T> Traverser<T> over(T ... items) {
        return Traversers.traverseArray(items);
    }
}

