/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.distributed.DistributedComparators;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class Distributed {
    private Distributed() {
    }

    public static final class Optional<T>
    implements Serializable {
        private static final Optional<?> EMPTY = new Optional();
        private final T value;

        private Optional() {
            this.value = null;
        }

        private Optional(T value) {
            this.value = Objects.requireNonNull(value);
        }

        public static <T> Optional<T> empty() {
            Optional<?> t = EMPTY;
            return t;
        }

        public static <T> Optional<T> of(T value) {
            return new Optional<T>(value);
        }

        public static <T> Optional<T> ofNullable(T value) {
            return value == null ? Optional.empty() : Optional.of(value);
        }

        public T get() {
            if (this.value == null) {
                throw new NoSuchElementException("No value present");
            }
            return this.value;
        }

        public boolean isPresent() {
            return this.value != null;
        }

        public void ifPresent(Consumer<? super T> consumer) {
            if (this.value != null) {
                consumer.accept(this.value);
            }
        }

        public Optional<T> filter(Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate);
            if (!this.isPresent()) {
                return this;
            }
            return predicate.test(this.value) ? this : Optional.empty();
        }

        public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
            Objects.requireNonNull(mapper);
            if (!this.isPresent()) {
                return Optional.empty();
            }
            return Optional.ofNullable(mapper.apply(this.value));
        }

        public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
            Objects.requireNonNull(mapper);
            if (!this.isPresent()) {
                return Optional.empty();
            }
            return Objects.requireNonNull(mapper.apply(this.value));
        }

        public T orElseGet(Supplier<? extends T> other) {
            return this.value != null ? this.value : other.get();
        }

        public T orElse(T other) {
            return this.value != null ? this.value : other;
        }

        public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            if (this.value != null) {
                return this.value;
            }
            throw (Throwable)exceptionSupplier.get();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Optional)) {
                return false;
            }
            Optional other = (Optional)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return this.value != null ? String.format("Optional[%s]", this.value) : "Optional.empty";
        }
    }

    @FunctionalInterface
    public static interface UnaryOperator<T>
    extends Function<T, T>,
    java.util.function.UnaryOperator<T>,
    Serializable {
        public static <T> UnaryOperator<T> identity() {
            return t -> t;
        }
    }

    @FunctionalInterface
    public static interface ToLongFunction<T>
    extends java.util.function.ToLongFunction<T>,
    Serializable {
    }

    @FunctionalInterface
    public static interface ToLongBiFunction<T, U>
    extends java.util.function.ToLongBiFunction<T, U>,
    Serializable {
    }

    @FunctionalInterface
    public static interface ToIntFunction<T>
    extends java.util.function.ToIntFunction<T>,
    Serializable {
    }

    @FunctionalInterface
    public static interface ToIntBiFunction<T, U>
    extends java.util.function.ToIntBiFunction<T, U>,
    Serializable {
    }

    @FunctionalInterface
    public static interface ToDoubleFunction<T>
    extends java.util.function.ToDoubleFunction<T>,
    Serializable {
    }

    @FunctionalInterface
    public static interface ToDoubleBiFunction<T, U>
    extends java.util.function.ToDoubleBiFunction<T, U>,
    Serializable {
    }

    @FunctionalInterface
    public static interface Supplier<T>
    extends java.util.function.Supplier<T>,
    Serializable {
        @Override
        public T get();
    }

    @FunctionalInterface
    public static interface Predicate<T>
    extends java.util.function.Predicate<T>,
    Serializable {
        public static <T> Predicate<T> isEqual(Object targetRef) {
            return null == targetRef ? Objects::isNull : object -> targetRef.equals(object);
        }

        @Override
        default public Predicate<T> and(Predicate<? super T> other) {
            Objects.requireNonNull(other);
            return t -> this.test(t) && other.test(t);
        }

        @Override
        default public Predicate<T> negate() {
            return t -> !this.test(t);
        }

        @Override
        default public Predicate<T> or(Predicate<? super T> other) {
            Objects.requireNonNull(other);
            return t -> this.test(t) || other.test(t);
        }
    }

    @FunctionalInterface
    public static interface ObjLongConsumer<T>
    extends java.util.function.ObjLongConsumer<T>,
    Serializable {
    }

    @FunctionalInterface
    public static interface ObjIntConsumer<T>
    extends java.util.function.ObjIntConsumer<T>,
    Serializable {
    }

    @FunctionalInterface
    public static interface ObjDoubleConsumer<T>
    extends java.util.function.ObjDoubleConsumer<T>,
    Serializable {
    }

    @FunctionalInterface
    public static interface LongUnaryOperator
    extends java.util.function.LongUnaryOperator,
    Serializable {
        public static LongUnaryOperator identity() {
            return t -> t;
        }

        default public LongUnaryOperator compose(LongUnaryOperator before) {
            Objects.requireNonNull(before);
            return v -> this.applyAsLong(before.applyAsLong(v));
        }

        default public LongUnaryOperator andThen(LongUnaryOperator after) {
            Objects.requireNonNull(after);
            return t -> after.applyAsLong(this.applyAsLong(t));
        }
    }

    @FunctionalInterface
    public static interface LongToIntFunction
    extends java.util.function.LongToIntFunction,
    Serializable {
    }

    @FunctionalInterface
    public static interface LongToDoubleFunction
    extends java.util.function.LongToDoubleFunction,
    Serializable {
    }

    @FunctionalInterface
    public static interface LongSupplier
    extends java.util.function.LongSupplier,
    Serializable {
    }

    @FunctionalInterface
    public static interface LongPredicate
    extends java.util.function.LongPredicate,
    Serializable {
        default public LongPredicate and(LongPredicate other) {
            Objects.requireNonNull(other);
            return value -> this.test(value) && other.test(value);
        }

        @Override
        default public LongPredicate negate() {
            return value -> !this.test(value);
        }

        default public LongPredicate or(LongPredicate other) {
            Objects.requireNonNull(other);
            return value -> this.test(value) || other.test(value);
        }
    }

    @FunctionalInterface
    public static interface LongFunction<R>
    extends java.util.function.LongFunction<R>,
    Serializable {
    }

    @FunctionalInterface
    public static interface LongConsumer
    extends java.util.function.LongConsumer,
    Serializable {
        default public LongConsumer andThen(LongConsumer after) {
            Objects.requireNonNull(after);
            return t -> {
                this.accept(t);
                after.accept(t);
            };
        }
    }

    @FunctionalInterface
    public static interface LongBinaryOperator
    extends java.util.function.LongBinaryOperator,
    Serializable {
    }

    @FunctionalInterface
    public static interface IntUnaryOperator
    extends java.util.function.IntUnaryOperator,
    Serializable {
        public static IntUnaryOperator identity() {
            return t -> t;
        }

        default public IntUnaryOperator compose(IntUnaryOperator before) {
            Objects.requireNonNull(before);
            return v -> this.applyAsInt(before.applyAsInt(v));
        }

        default public IntUnaryOperator andThen(IntUnaryOperator after) {
            Objects.requireNonNull(after);
            return t -> after.applyAsInt(this.applyAsInt(t));
        }
    }

    @FunctionalInterface
    public static interface IntToLongFunction
    extends java.util.function.IntToLongFunction,
    Serializable {
    }

    @FunctionalInterface
    public static interface IntToDoubleFunction
    extends java.util.function.IntToDoubleFunction,
    Serializable {
    }

    @FunctionalInterface
    public static interface IntSupplier
    extends java.util.function.IntSupplier,
    Serializable {
    }

    @FunctionalInterface
    public static interface IntPredicate
    extends java.util.function.IntPredicate,
    Serializable {
        default public IntPredicate and(IntPredicate other) {
            Objects.requireNonNull(other);
            return value -> this.test(value) && other.test(value);
        }

        @Override
        default public IntPredicate negate() {
            return value -> !this.test(value);
        }

        default public IntPredicate or(IntPredicate other) {
            Objects.requireNonNull(other);
            return value -> this.test(value) || other.test(value);
        }
    }

    @FunctionalInterface
    public static interface IntFunction<R>
    extends java.util.function.IntFunction<R>,
    Serializable {
    }

    @FunctionalInterface
    public static interface IntConsumer
    extends java.util.function.IntConsumer,
    Serializable {
        default public IntConsumer andThen(IntConsumer after) {
            Objects.requireNonNull(after);
            return t -> {
                this.accept(t);
                after.accept(t);
            };
        }
    }

    @FunctionalInterface
    public static interface IntBinaryOperator
    extends java.util.function.IntBinaryOperator,
    Serializable {
    }

    @FunctionalInterface
    public static interface Function<T, R>
    extends java.util.function.Function<T, R>,
    Serializable {
        public static <T> Function<T, T> identity() {
            return t -> t;
        }

        @Override
        public R apply(T var1);

        @Override
        default public <V> Function<V, R> compose(Function<? super V, ? extends T> before) {
            Objects.requireNonNull(before);
            return v -> this.apply(before.apply((Object)v));
        }

        @Override
        default public <V> Function<T, V> andThen(Function<? super R, ? extends V> after) {
            Objects.requireNonNull(after);
            return t -> after.apply((R)this.apply(t));
        }
    }

    @FunctionalInterface
    public static interface DoubleUnaryOperator
    extends java.util.function.DoubleUnaryOperator,
    Serializable {
        public static DoubleUnaryOperator identity() {
            return t -> t;
        }

        default public DoubleUnaryOperator compose(DoubleUnaryOperator before) {
            Objects.requireNonNull(before);
            return v -> this.applyAsDouble(before.applyAsDouble(v));
        }

        default public DoubleUnaryOperator andThen(DoubleUnaryOperator after) {
            Objects.requireNonNull(after);
            return t -> after.applyAsDouble(this.applyAsDouble(t));
        }
    }

    @FunctionalInterface
    public static interface DoubleToLongFunction
    extends java.util.function.DoubleToLongFunction,
    Serializable {
    }

    @FunctionalInterface
    public static interface DoubleToIntFunction
    extends java.util.function.DoubleToIntFunction,
    Serializable {
    }

    @FunctionalInterface
    public static interface DoubleSupplier
    extends java.util.function.DoubleSupplier,
    Serializable {
    }

    @FunctionalInterface
    public static interface DoublePredicate
    extends java.util.function.DoublePredicate,
    Serializable {
        default public DoublePredicate and(DoublePredicate other) {
            Objects.requireNonNull(other);
            return value -> this.test(value) && other.test(value);
        }

        @Override
        default public DoublePredicate negate() {
            return value -> !this.test(value);
        }

        default public DoublePredicate or(DoublePredicate other) {
            Objects.requireNonNull(other);
            return value -> this.test(value) || other.test(value);
        }
    }

    @FunctionalInterface
    public static interface DoubleFunction<R>
    extends java.util.function.DoubleFunction<R>,
    Serializable {
    }

    @FunctionalInterface
    public static interface DoubleConsumer
    extends java.util.function.DoubleConsumer,
    Serializable {
        default public DoubleConsumer andThen(DoubleConsumer after) {
            Objects.requireNonNull(after);
            return t -> {
                this.accept(t);
                after.accept(t);
            };
        }
    }

    @FunctionalInterface
    public static interface DoubleBinaryOperator
    extends java.util.function.DoubleBinaryOperator,
    Serializable {
    }

    @FunctionalInterface
    public static interface Consumer<T>
    extends java.util.function.Consumer<T>,
    Serializable {
        @Override
        public void accept(T var1);

        @Override
        default public Consumer<T> andThen(Consumer<? super T> after) {
            Objects.requireNonNull(after);
            return t -> {
                this.accept(t);
                after.accept(t);
            };
        }
    }

    @FunctionalInterface
    public static interface Comparator<T>
    extends java.util.Comparator<T>,
    Serializable {
        public static <T extends Comparable<? super T>> Comparator<T> naturalOrder() {
            return DistributedComparators.NATURAL_ORDER_COMPARATOR;
        }

        public static <T extends Comparable<? super T>> Comparator<T> reverseOrder() {
            return DistributedComparators.REVERSE_ORDER_COMPARATOR;
        }

        public static <T> Comparator<T> nullsFirst(java.util.Comparator<? super T> comparator) {
            StreamUtil.checkSerializable(comparator, "comparator");
            return new DistributedComparators.NullComparator<T>(true, comparator);
        }

        public static <T> Comparator<T> nullsFirst(Comparator<? super T> comparator) {
            return Comparator.nullsFirst(comparator);
        }

        public static <T> Comparator<T> nullsLast(java.util.Comparator<? super T> comparator) {
            StreamUtil.checkSerializable(comparator, "comparator");
            return new DistributedComparators.NullComparator<T>(false, comparator);
        }

        public static <T> Comparator<T> nullsLast(Comparator<? super T> comparator) {
            return Comparator.nullsLast(comparator);
        }

        public static <T, U> Comparator<T> comparing(java.util.function.Function<? super T, ? extends U> keyExtractor, java.util.Comparator<? super U> keyComparator) {
            Objects.requireNonNull(keyExtractor);
            Objects.requireNonNull(keyComparator);
            StreamUtil.checkSerializable(keyExtractor, "keyExtractor");
            StreamUtil.checkSerializable(keyComparator, "keyComparator");
            return (c1, c2) -> keyComparator.compare((Object)keyExtractor.apply(c1), (Object)keyExtractor.apply(c2));
        }

        public static <T, U> Comparator<T> comparing(Function<? super T, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
            return Comparator.comparing(keyExtractor, keyComparator);
        }

        public static <T, U extends Comparable<? super U>> Comparator<T> comparing(java.util.function.Function<? super T, ? extends U> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            StreamUtil.checkSerializable(keyExtractor, "keyExtractor");
            return (c1, c2) -> ((Comparable)keyExtractor.apply(c1)).compareTo(keyExtractor.apply(c2));
        }

        public static <T, U extends Comparable<? super U>> Comparator<T> comparing(Function<? super T, ? extends U> keyExtractor) {
            return Comparator.comparing(keyExtractor);
        }

        public static <T> Comparator<T> comparingInt(java.util.function.ToIntFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            StreamUtil.checkSerializable(keyExtractor, "keyExtractor");
            return (c1, c2) -> Integer.compare(keyExtractor.applyAsInt(c1), keyExtractor.applyAsInt(c2));
        }

        public static <T> Comparator<T> comparingInt(ToIntFunction<? super T> keyExtractor) {
            return Comparator.comparingInt(keyExtractor);
        }

        public static <T> Comparator<T> comparingLong(java.util.function.ToLongFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            StreamUtil.checkSerializable(keyExtractor, "keyExtractor");
            return (c1, c2) -> Long.compare(keyExtractor.applyAsLong(c1), keyExtractor.applyAsLong(c2));
        }

        public static <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
            return Comparator.comparingLong(keyExtractor);
        }

        public static <T> Comparator<T> comparingDouble(java.util.function.ToDoubleFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            StreamUtil.checkSerializable(keyExtractor, "keyExtractor");
            return (c1, c2) -> Double.compare(keyExtractor.applyAsDouble(c1), keyExtractor.applyAsDouble(c2));
        }

        public static <T> Comparator<T> comparingDouble(ToDoubleFunction<? super T> keyExtractor) {
            return Comparator.comparingDouble(keyExtractor);
        }

        @Override
        default public Comparator<T> thenComparing(java.util.Comparator<? super T> other) {
            Objects.requireNonNull(other);
            StreamUtil.checkSerializable(other, "other");
            return (c1, c2) -> {
                int res = this.compare(c1, c2);
                return res != 0 ? res : other.compare(c1, c2);
            };
        }

        @Override
        default public Comparator<T> thenComparing(Comparator<? super T> other) {
            return this.thenComparing((java.util.Comparator)other);
        }

        @Override
        default public <U> Comparator<T> thenComparing(java.util.function.Function<? super T, ? extends U> keyExtractor, java.util.Comparator<? super U> keyComparator) {
            StreamUtil.checkSerializable(keyExtractor, "keyExtractor");
            StreamUtil.checkSerializable(keyComparator, "keyComparator");
            return this.thenComparing(Comparator.comparing(keyExtractor, keyComparator));
        }

        @Override
        default public <U> Comparator<T> thenComparing(Function<? super T, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
            return this.thenComparing((java.util.function.Function)keyExtractor, (java.util.Comparator)keyComparator);
        }

        @Override
        default public <U extends Comparable<? super U>> Comparator<T> thenComparing(java.util.function.Function<? super T, ? extends U> keyExtractor) {
            StreamUtil.checkSerializable(keyExtractor, "keyExtractor");
            return this.thenComparing(Comparator.comparing(keyExtractor));
        }

        @Override
        default public <U extends Comparable<? super U>> Comparator<T> thenComparing(Function<? super T, ? extends U> keyExtractor) {
            return this.thenComparing((java.util.function.Function)keyExtractor);
        }

        @Override
        default public Comparator<T> thenComparingInt(java.util.function.ToIntFunction<? super T> keyExtractor) {
            StreamUtil.checkSerializable(keyExtractor, "keyExtractor");
            return this.thenComparing(Comparator.comparingInt(keyExtractor));
        }

        @Override
        default public Comparator<T> thenComparingInt(ToIntFunction<? super T> keyExtractor) {
            return this.thenComparingInt((java.util.function.ToIntFunction)keyExtractor);
        }

        @Override
        default public Comparator<T> thenComparingLong(java.util.function.ToLongFunction<? super T> keyExtractor) {
            StreamUtil.checkSerializable(keyExtractor, "keyExtractor");
            return this.thenComparing(Comparator.comparingLong(keyExtractor));
        }

        @Override
        default public Comparator<T> thenComparingLong(ToLongFunction<? super T> keyExtractor) {
            return this.thenComparingLong((java.util.function.ToLongFunction)keyExtractor);
        }

        @Override
        default public Comparator<T> thenComparingDouble(java.util.function.ToDoubleFunction<? super T> keyExtractor) {
            StreamUtil.checkSerializable(keyExtractor, "keyExtractor");
            return this.thenComparing(Comparator.comparingDouble(keyExtractor));
        }

        @Override
        default public Comparator<T> thenComparingDouble(ToDoubleFunction<? super T> keyExtractor) {
            return this.thenComparingDouble((java.util.function.ToDoubleFunction)keyExtractor);
        }
    }

    @FunctionalInterface
    public static interface BooleanSupplier
    extends java.util.function.BooleanSupplier,
    Serializable {
    }

    @FunctionalInterface
    public static interface BinaryOperator<T>
    extends java.util.function.BinaryOperator<T>,
    Serializable {
        public static <T> BinaryOperator<T> minBy(java.util.Comparator<? super T> comparator) {
            Objects.requireNonNull(comparator);
            return (a, b) -> comparator.compare(a, b) <= 0 ? a : b;
        }

        public static <T> BinaryOperator<T> maxBy(java.util.Comparator<? super T> comparator) {
            Objects.requireNonNull(comparator);
            return (a, b) -> comparator.compare(a, b) >= 0 ? a : b;
        }
    }

    @FunctionalInterface
    public static interface BiPredicate<T, U>
    extends java.util.function.BiPredicate<T, U>,
    Serializable {
        @Override
        default public BiPredicate<T, U> and(BiPredicate<? super T, ? super U> other) {
            Objects.requireNonNull(other);
            return (t, u) -> this.test(t, u) && other.test(t, u);
        }

        @Override
        default public BiPredicate<T, U> negate() {
            return (t, u) -> !this.test(t, u);
        }

        @Override
        default public BiPredicate<T, U> or(BiPredicate<? super T, ? super U> other) {
            Objects.requireNonNull(other);
            return (t, u) -> this.test(t, u) || other.test(t, u);
        }
    }

    @FunctionalInterface
    public static interface BiFunction<T, U, R>
    extends java.util.function.BiFunction<T, U, R>,
    Serializable {
        @Override
        public R apply(T var1, U var2);

        @Override
        default public <V> BiFunction<T, U, V> andThen(Function<? super R, ? extends V> after) {
            Objects.requireNonNull(after);
            return (t, u) -> after.apply((R)this.apply(t, u));
        }
    }

    @FunctionalInterface
    public static interface BiConsumer<T, U>
    extends java.util.function.BiConsumer<T, U>,
    Serializable {
        @Override
        public void accept(T var1, U var2);

        @Override
        default public BiConsumer<T, U> andThen(BiConsumer<? super T, ? super U> after) {
            Objects.requireNonNull(after);
            return (l, r) -> {
                this.accept(l, r);
                after.accept(l, r);
            };
        }
    }
}

