/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.tfidf;

import com.hazelcast.jet.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class SearchGui {
    private static final int WINDOW_X = 200;
    private static final int WINDOW_Y = 200;
    private static final int WINDOW_WIDTH = 300;
    private static final int WINDOW_HEIGHT = 350;
    private final Map<String, List<Map.Entry<String, Double>>> invertedIndex;
    private final Set<String> stopwords;

    SearchGui(Map<String, List<Map.Entry<String, Double>>> invertedIndex, Set<String> stopwords) {
        this.invertedIndex = invertedIndex;
        this.stopwords = stopwords;
        EventQueue.invokeLater(this::buildFrame);
    }

    private void buildFrame() {
        JFrame frame = new JFrame();
        frame.setBackground(Color.WHITE);
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Hazelcast Jet TF-IDF - Pipeline API");
        frame.setBounds(200, 200, 300, 350);
        frame.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(10, 10));
        frame.add(mainPanel);
        final JTextField input = new JTextField();
        mainPanel.add((Component)input, "North");
        final JTextArea output = new JTextArea();
        mainPanel.add((Component)output, "Center");
        input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                EventQueue.invokeLater(() -> output.setText(SearchGui.this.search(input.getText().split("\\s+"))));
            }
        });
        frame.setVisible(true);
    }

    private String search(String ... terms) {
        Map<Boolean, List<String>> byStopword = Arrays.stream(terms).map(String::toLowerCase).collect(Collectors.partitioningBy(this.stopwords::contains));
        List<String> searchTerms = byStopword.get(false);
        String stopwordLine = byStopword.get(true).stream().collect(Collectors.joining(" "));
        return (!stopwordLine.isEmpty() ? "Stopwords: " + stopwordLine + "\n--------\n" : "") + searchTerms.stream().flatMap(term -> this.invertedIndex.getOrDefault(term, Collections.emptyList()).stream()).collect(Collectors.toMap(Map.Entry::getKey, e -> Util.entry((Object)1, e.getValue()), (o, n) -> Util.entry((Object)((Integer)o.getKey() + (Integer)n.getKey()), (Object)((Double)o.getValue() + (Double)n.getValue())))).entrySet().stream().filter(e -> ((Integer)((Map.Entry)e.getValue()).getKey()).intValue() == searchTerms.size()).sorted(Comparator.comparingDouble(e -> (Double)((Map.Entry)e.getValue()).getValue()).reversed()).map(e -> String.format("%5.2f %s", (Double)((Map.Entry)e.getValue()).getValue() / (double)terms.length, e.getKey())).collect(Collectors.joining("\n"));
    }
}

