/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.spring;

import com.hazelcast.collection.IList;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.examples.spring.config.AppConfig;
import com.hazelcast.jet.examples.spring.dao.UserDao;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.spring.JetSpringServiceFactories;
import java.io.Serializable;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class BeanAsAServiceSample {
    private static final String LIST_NAME = "source-list";

    public static void main(String[] args) throws Exception {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{AppConfig.class});
        JetInstance jet = (JetInstance)context.getBean(JetInstance.class);
        BeanAsAServiceSample.fillList(jet);
        Pipeline pipeline = Pipeline.create();
        pipeline.readFrom(Sources.list((String)LIST_NAME)).mapUsingService(JetSpringServiceFactories.bean(UserDao.class), (BiFunctionEx & Serializable)(userDao, item) -> userDao.findByName(item.toLowerCase())).writeTo(Sinks.logger());
        jet.newJob(pipeline).join();
        jet.shutdown();
    }

    private static void fillList(JetInstance jet) {
        IList list = jet.getList(LIST_NAME);
        if (list.isEmpty()) {
            list.add((Object)"JOE");
            list.add((Object)"ALICE");
            list.add((Object)"BOB");
            list.add((Object)"FOO");
        }
    }
}

