/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.sinkbuilder;

import com.hazelcast.core.ITopic;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.function.BiConsumerEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.PredicateEx;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.SinkBuilder;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.util.ExceptionUtil;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.function.Consumer;

public class TopicSink {
    private static final String TOPIC_NAME = "topic";

    private static Pipeline buildPipeline() {
        Pipeline p = Pipeline.create();
        p.drawFrom(Sources.files((String)TopicSink.getBooksPath())).filter((PredicateEx & Serializable)line -> line.startsWith("The ")).drainTo(TopicSink.buildTopicSink());
        return p;
    }

    private static Sink<String> buildTopicSink() {
        return SinkBuilder.sinkBuilder((String)"topicSink(topic)", (FunctionEx & Serializable)jet -> jet.jetInstance().getHazelcastInstance().getTopic(TOPIC_NAME)).receiveFn((BiConsumerEx & Serializable)(topic, message) -> topic.publish(message)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            System.out.println("Creating Jet instance 1");
            JetInstance jet = Jet.newJetInstance();
            System.out.println("Creating Jet instance 2");
            Jet.newJetInstance();
            System.out.println("Configure Topic Listener");
            ITopic topic = jet.getHazelcastInstance().getTopic(TOPIC_NAME);
            TopicSink.addListener((ITopic<String>)topic, e -> System.out.println("Line starts with `The`: " + e));
            System.out.println("\nRunning the pipeline");
            Pipeline p = TopicSink.buildPipeline();
            jet.newJob(p).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private static String getBooksPath() {
        try {
            return Paths.get(TopicSink.class.getResource("/books").toURI()).toString();
        }
        catch (URISyntaxException e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private static void addListener(ITopic<String> topic, Consumer<String> consumer) {
        topic.addMessageListener(event -> consumer.accept((String)event.getMessageObject()));
    }
}

