/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.slidingwindow;

import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.examples.slidingwindow.Trade;
import com.hazelcast.jet.examples.slidingwindow.TradeGenerator;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.WindowDefinition;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;

public class StockExchange {
    private static final int SLIDING_WINDOW_LENGTH_MILLIS = 3000;
    private static final int SLIDE_STEP_MILLIS = 500;
    private static final int TRADES_PER_SEC = 3000;
    private static final int NUMBER_OF_TICKERS = 10;
    private static final int JOB_DURATION = 15;

    private static Pipeline buildPipeline() {
        Pipeline p = Pipeline.create();
        p.drawFrom(TradeGenerator.tradeSource(10, 3000)).withNativeTimestamps(3000L).groupingKey(Trade::getTicker).window((WindowDefinition)WindowDefinition.sliding((long)3000L, (long)500L)).aggregate(AggregateOperations.counting()).drainTo(Sinks.logger((FunctionEx & Serializable)wr -> String.format("%s %5s %4d", StockExchange.toLocalTime(wr.end()), wr.key(), wr.result())));
        return p;
    }

    public static void main(String[] args) throws InterruptedException {
        JetInstance jet = Jet.newJetInstance();
        Jet.newJetInstance();
        try {
            Job job = jet.newJob(StockExchange.buildPipeline());
            TimeUnit.SECONDS.sleep(15L);
            job.cancel();
            job.join();
        }
        catch (CancellationException cancellationException) {
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private static LocalTime toLocalTime(long timestamp) {
        return Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalTime();
    }
}

