/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.kafka.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.jet.IMapJet;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.examples.kafka.json.User;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.kafka.KafkaSources;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils;
import kafka.admin.RackAwareMode;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.json.JsonDeserializer;
import org.apache.kafka.connect.json.JsonSerializer;

public class KafkaJsonSource {
    private static final String ZK_HOST = "127.0.0.1";
    private static final String BROKER_HOST = "127.0.0.1";
    private static final int SESSION_TIMEOUT = 30000;
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final String AUTO_OFFSET_RESET = "earliest";
    private static final String TOPIC = "topic";
    private static final String SINK_MAP_NAME = "users";
    private EmbeddedZookeeper zkServer;
    private ZkUtils zkUtils;
    private KafkaServer kafkaServer;
    private int brokerPort;

    private Pipeline buildPipeline() {
        Pipeline p = Pipeline.create();
        p.drawFrom(KafkaSources.kafka((Properties)KafkaJsonSource.props("bootstrap.servers", "127.0.0.1:" + this.brokerPort, "group.id", "0", "key.deserializer", IntegerDeserializer.class.getName(), "value.deserializer", JsonDeserializer.class.getName(), "auto.offset.reset", AUTO_OFFSET_RESET), (String[])new String[]{TOPIC})).withoutTimestamps().peek().drainTo(Sinks.map((String)SINK_MAP_NAME));
        return p;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("hazelcast.logging.type", "log4j");
        new KafkaJsonSource().go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void go() throws Exception {
        try {
            this.createKafkaCluster();
            this.createAndFillTopic();
            JetConfig jetConfig = this.getJetConfigWithCustomSerialization();
            JetInstance jet = Jet.newJetInstance((JetConfig)jetConfig);
            Jet.newJetInstance((JetConfig)jetConfig);
            long start = System.nanoTime();
            Job job = jet.newJob(this.buildPipeline());
            IMapJet sinkMap = jet.getMap(SINK_MAP_NAME);
            while (true) {
                int mapSize = sinkMap.size();
                System.out.format("Received %d entries in %d milliseconds.%n", mapSize, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                if (mapSize == 20) {
                    TimeUnit.SECONDS.sleep(1L);
                    KafkaJsonSource.cancel(job);
                    break;
                }
                Thread.sleep(100L);
            }
        }
        finally {
            Jet.shutdownAll();
            this.shutdownKafkaCluster();
        }
    }

    private JetConfig getJetConfigWithCustomSerialization() {
        JetConfig jetConfig = new JetConfig();
        SerializerConfig serializerConfig = new SerializerConfig();
        serializerConfig.setTypeClass(JsonNode.class);
        serializerConfig.setImplementation((Serializer)new StreamSerializer<JsonNode>(){
            private ObjectMapper objectMapper = new ObjectMapper();

            public int getTypeId() {
                return 1;
            }

            public void destroy() {
            }

            public void write(ObjectDataOutput objectDataOutput, JsonNode jsonNode) throws IOException {
                byte[] bytes = this.objectMapper.writeValueAsBytes((Object)jsonNode);
                objectDataOutput.write(bytes);
            }

            public JsonNode read(ObjectDataInput objectDataInput) throws IOException {
                return (JsonNode)this.objectMapper.readValue(objectDataInput.readByteArray(), JsonNode.class);
            }
        });
        jetConfig.getHazelcastConfig().getSerializationConfig().addSerializerConfig(serializerConfig);
        return jetConfig;
    }

    private void createAndFillTopic() {
        AdminUtils.createTopic((ZkUtils)this.zkUtils, (String)TOPIC, (int)4, (int)1, (Properties)new Properties(), (RackAwareMode)RackAwareMode.Disabled$.MODULE$);
        Properties props = KafkaJsonSource.props("bootstrap.servers", "127.0.0.1:" + this.brokerPort, "key.serializer", IntegerSerializer.class.getName(), "value.serializer", JsonSerializer.class.getName());
        ObjectMapper mapper = new ObjectMapper();
        try (KafkaProducer producer = new KafkaProducer(props);){
            for (int i = 0; i < 20; ++i) {
                User user = new User("name" + i, "pass" + i, i, i % 2 == 0);
                producer.send(new ProducerRecord(TOPIC, (Object)i, (Object)mapper.valueToTree((Object)user)));
            }
        }
    }

    private void createKafkaCluster() throws IOException {
        System.setProperty("zookeeper.preAllocSize", Integer.toString(128));
        this.zkServer = new EmbeddedZookeeper();
        String zkConnect = "127.0.0.1:" + this.zkServer.port();
        ZkClient zkClient = new ZkClient(zkConnect, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
        this.zkUtils = ZkUtils.apply((ZkClient)zkClient, (boolean)false);
        this.brokerPort = KafkaJsonSource.randomPort();
        KafkaConfig config = new KafkaConfig((Map)KafkaJsonSource.props("zookeeper.connect", zkConnect, "broker.id", "0", "log.dirs", Files.createTempDirectory("kafka-", new FileAttribute[0]).toAbsolutePath().toString(), "listeners", "PLAINTEXT://127.0.0.1:" + this.brokerPort, "offsets.topic.replication.factor", "1", "offsets.topic.num.partitions", "1"));
        MockTime mock = new MockTime();
        this.kafkaServer = TestUtils.createServer((KafkaConfig)config, (Time)mock);
    }

    private void shutdownKafkaCluster() {
        this.kafkaServer.shutdown();
        this.zkUtils.close();
        this.zkServer.shutdown();
    }

    private static void cancel(Job job) {
        job.cancel();
        while (job.getStatus() != JobStatus.FAILED) {
            Util.uncheckRun(() -> TimeUnit.SECONDS.sleep(1L));
        }
    }

    private static int randomPort() throws IOException {
        try (ServerSocket server = null;){
            server = new ServerSocket(0);
            int n = server.getLocalPort();
            return n;
        }
    }

    private static Properties props(String ... kvs) {
        Properties props = new Properties();
        int i = 0;
        while (i < kvs.length) {
            props.setProperty(kvs[i++], kvs[i++]);
        }
        return props;
    }
}

