/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.hadoop;

import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.Functions;
import com.hazelcast.jet.hadoop.HdfsSinks;
import com.hazelcast.jet.hadoop.HdfsSources;
import com.hazelcast.jet.pipeline.Pipeline;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;

public class HadoopWordCount {
    private static final String OUTPUT_PATH = "hadoop-word-count";

    private static Pipeline buildPipeline(Path inputPath, Path outputPath) {
        JobConf jobConfig = new JobConf();
        jobConfig.setInputFormat(TextInputFormat.class);
        jobConfig.setOutputFormat(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((JobConf)jobConfig, (Path)outputPath);
        TextInputFormat.addInputPath((JobConf)jobConfig, (Path)inputPath);
        Pattern regex = Pattern.compile("\\W+");
        Pipeline p = Pipeline.create();
        p.drawFrom(HdfsSources.hdfs((JobConf)jobConfig, (BiFunctionEx & Serializable)(k, v) -> v.toString())).flatMap((FunctionEx & Serializable)line -> Traversers.traverseArray((Object[])regex.split(line.toLowerCase())).filter(w -> !w.isEmpty())).groupingKey(Functions.wholeItem()).aggregate(AggregateOperations.counting()).drainTo(HdfsSinks.hdfs((JobConf)jobConfig));
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Path inputPath = new Path(HadoopWordCount.class.getResource("/books").getPath());
        Path outputPath = new Path(OUTPUT_PATH);
        FileSystem.get((Configuration)new Configuration()).delete(outputPath, true);
        try {
            JetInstance jet = Jet.newJetInstance();
            Jet.newJetInstance();
            System.out.print("\nCounting words from " + inputPath);
            long start = System.nanoTime();
            Pipeline p = HadoopWordCount.buildPipeline(inputPath, outputPath);
            jet.newJob(p).join();
            System.out.println("Done in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " milliseconds.");
            System.out.println("Output written to " + outputPath);
        }
        finally {
            Jet.shutdownAll();
        }
    }
}

