/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.hadoop.avro;

import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.examples.hadoop.avro.User;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.PredicateEx;
import com.hazelcast.jet.hadoop.HdfsSinks;
import com.hazelcast.jet.hadoop.HdfsSources;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Pipeline;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.stream.IntStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.AvroInputFormat;
import org.apache.avro.mapred.AvroOutputFormat;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

public class HadoopAvro {
    private static final String MODULE_DIRECTORY = HadoopAvro.moduleDirectory();
    private static final String INPUT_PATH = MODULE_DIRECTORY + "/hdfs-avro-input";
    private static final String OUTPUT_PATH = MODULE_DIRECTORY + "/hdfs-avro-output";

    private static Pipeline buildPipeline(JobConf jobConfig) {
        Pipeline p = Pipeline.create();
        p.drawFrom(HdfsSources.hdfs((JobConf)jobConfig)).filter((PredicateEx & Serializable)entry -> ((User)((AvroWrapper)entry.getKey()).datum()).get(3).equals(Boolean.TRUE)).peek((FunctionEx & Serializable)entry -> ((User)((AvroWrapper)entry.getKey()).datum()).toString()).drainTo(HdfsSinks.hdfs((JobConf)jobConfig));
        return p;
    }

    public static void main(String[] args) throws Exception {
        new HadoopAvro().go();
    }

    private void go() throws Exception {
        try {
            this.createAvroFile();
            JetInstance jet = Jet.newJetInstance();
            JobConf jobConfig = this.createJobConfig();
            jet.newJob(HadoopAvro.buildPipeline(jobConfig)).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private JobConf createJobConfig() throws IOException {
        Path inputPath = new Path(INPUT_PATH);
        Path outputPath = new Path(OUTPUT_PATH);
        FileSystem.get((Configuration)new Configuration()).delete(outputPath, true);
        JobConf jobConfig = new JobConf();
        jobConfig.setInputFormat(AvroInputFormat.class);
        jobConfig.setOutputFormat(AvroOutputFormat.class);
        AvroOutputFormat.setOutputPath((JobConf)jobConfig, (Path)outputPath);
        AvroInputFormat.addInputPath((JobConf)jobConfig, (Path)inputPath);
        jobConfig.set("avro.output.schema", User.SCHEMA.toString());
        jobConfig.set("avro.input.schema", User.SCHEMA.toString());
        return jobConfig;
    }

    private void createAvroFile() throws IOException {
        Path inputPath = new Path(INPUT_PATH);
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        fs.delete(inputPath, true);
        DataFileWriter fileWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(User.SCHEMA));
        fileWriter.create(User.SCHEMA, (OutputStream)fs.create(new Path(inputPath, "file.avro")));
        IntStream.range(0, 100).mapToObj(i -> new User("name" + i, "pass" + i, i, i % 2 == 0)).forEach(user -> Util.uncheckRun(() -> fileWriter.append(user)));
        fileWriter.close();
        fs.close();
    }

    private static String moduleDirectory() {
        String resourcePath = HadoopAvro.class.getClassLoader().getResource("").getPath();
        return Paths.get(resourcePath, new String[0]).getParent().getParent().toString();
    }
}

