/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.files.s3;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.Functions;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.s3.S3Sinks;
import com.hazelcast.jet.s3.S3Sources;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;

public class S3WordCount {
    private static final String INPUT_BUCKET = "jet-s3-example-input-bucket";
    private static final String OUTPUT_BUCKET = "jet-s3-example-output-bucket";
    private static final String PREFIX = "books/";

    private static Pipeline buildPipeline() {
        Pattern regex = Pattern.compile("\\W+");
        Pipeline p = Pipeline.create();
        p.readFrom(S3Sources.s3(Collections.singletonList(INPUT_BUCKET), (String)PREFIX, (Charset)StandardCharsets.UTF_8, S3WordCount::createClient, (BiFunctionEx & Serializable)(name, line) -> line)).flatMap((FunctionEx & Serializable)line -> Traversers.traverseArray((Object[])regex.split(line.toLowerCase())).filter(w -> !w.isEmpty())).groupingKey(Functions.wholeItem()).aggregate(AggregateOperations.counting()).writeTo(S3Sinks.s3((String)OUTPUT_BUCKET, (String)PREFIX, (Charset)StandardCharsets.UTF_8, S3WordCount::createClient, Object::toString));
        return p;
    }

    private static S3Client createClient() {
        return S3Client.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        System.setProperty(SdkSystemSetting.AWS_ACCESS_KEY_ID.property(), "");
        System.setProperty(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), "");
        try {
            System.out.println("Uploading books to bucket jet-s3-example-input-bucket");
            S3WordCount.uploadBooks(PREFIX);
            JetInstance jet = Jet.bootstrappedInstance();
            System.out.print("\nCounting words from jet-s3-example-input-bucket");
            long start = System.nanoTime();
            Pipeline p = S3WordCount.buildPipeline();
            jet.newJob(p).join();
            System.out.println("Done in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " milliseconds.");
            System.out.println("Output written to jet-s3-example-output-bucket");
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private static void uploadBooks(String prefix) throws IOException {
        try (S3Client s3Client = S3WordCount.createClient();){
            Path path = Paths.get(S3WordCount.class.getResource("/books").getPath(), new String[0]);
            Files.list(path).limit(10L).forEach(book -> {
                System.out.println("Uploading file " + book.getFileName().toString() + "...");
                s3Client.putObject(req -> req.bucket(INPUT_BUCKET).key(prefix + book.getFileName().toString()), RequestBody.fromFile((File)book.toFile()));
            });
        }
    }
}

