/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.eventjournal;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.cluster.Address;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.pipeline.JournalInitialPosition;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.map.IMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class RemoteMapJournalSource {
    private static final String MAP_NAME = "map";
    private static final String SINK_NAME = "list";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config hzConfig = RemoteMapJournalSource.getConfig();
        HazelcastInstance remoteHz = RemoteMapJournalSource.startRemoteHzCluster(hzConfig);
        JetInstance localJet = RemoteMapJournalSource.startLocalJetCluster();
        try {
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.getNetworkConfig().addAddress(new String[]{RemoteMapJournalSource.getAddress(remoteHz)});
            clientConfig.setClusterName(hzConfig.getClusterName());
            Pipeline p = Pipeline.create();
            p.readFrom(Sources.remoteMapJournal((String)MAP_NAME, (ClientConfig)clientConfig, (JournalInitialPosition)JournalInitialPosition.START_FROM_OLDEST)).withoutTimestamps().map(Map.Entry::getValue).writeTo(Sinks.list((String)SINK_NAME));
            localJet.newJob(p);
            IMap map = remoteHz.getMap(MAP_NAME);
            for (int i = 0; i < 1000; ++i) {
                map.set((Object)i, (Object)i);
            }
            TimeUnit.SECONDS.sleep(3L);
            System.out.println("Read " + localJet.getList(SINK_NAME).size() + " entries from remote map journal.");
        }
        finally {
            Hazelcast.shutdownAll();
            Jet.shutdownAll();
        }
    }

    private static String getAddress(HazelcastInstance remoteHz) {
        Address address = remoteHz.getCluster().getLocalMember().getAddress();
        return address.getHost() + ":" + address.getPort();
    }

    private static JetInstance startLocalJetCluster() {
        JetInstance localJet = Jet.newJetInstance();
        Jet.newJetInstance();
        return localJet;
    }

    private static HazelcastInstance startRemoteHzCluster(Config config) {
        HazelcastInstance remoteHz = Hazelcast.newHazelcastInstance((Config)config);
        Hazelcast.newHazelcastInstance((Config)config);
        return remoteHz;
    }

    private static Config getConfig() {
        Config config = new Config();
        config.getMapConfig(MAP_NAME).getEventJournalConfig().setEnabled(true).setCapacity(10000).setTimeToLiveSeconds(10);
        return config;
    }
}

