/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.eventjournal;

import com.hazelcast.jet.IMapJet;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.pipeline.JournalInitialPosition;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MapJournalSource {
    private static final String MAP_NAME = "map";
    private static final String SINK_NAME = "list";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.setProperty("hazelcast.logging.type", "log4j");
        JetConfig jetConfig = MapJournalSource.getJetConfig();
        JetInstance jet = Jet.newJetInstance((JetConfig)jetConfig);
        Jet.newJetInstance((JetConfig)jetConfig);
        try {
            Pipeline p = Pipeline.create();
            p.drawFrom(Sources.mapJournal((String)MAP_NAME, (JournalInitialPosition)JournalInitialPosition.START_FROM_OLDEST)).withoutTimestamps().map(Map.Entry::getValue).drainTo(Sinks.list((String)SINK_NAME));
            jet.newJob(p);
            IMapJet map = jet.getMap(MAP_NAME);
            for (int i = 0; i < 1000; ++i) {
                map.set((Object)i, (Object)i);
            }
            TimeUnit.SECONDS.sleep(3L);
            System.out.println("Read " + jet.getList(SINK_NAME).size() + " entries from map journal.");
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private static JetConfig getJetConfig() {
        JetConfig cfg = new JetConfig();
        cfg.getHazelcastConfig().getMapEventJournalConfig(MAP_NAME).setEnabled(true).setCapacity(1000).setTimeToLiveSeconds(10);
        return cfg;
    }
}

