/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import antlr.ANTLRException;
import hudson.model.Job;
import hudson.triggers.Trigger;
import hudson.util.DescribableList;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ghprb.GhprbGitHubAuth;
import org.jenkinsci.plugins.ghprb.GhprbPullRequest;
import org.jenkinsci.plugins.ghprb.extensions.GhprbExtension;
import org.jenkinsci.plugins.ghprb.extensions.GhprbExtensionDescriptor;
import org.jenkinsci.plugins.ghprb.extensions.comments.GhprbBuildResultMessage;
import org.jenkinsci.plugins.ghprb.extensions.comments.GhprbBuildStatus;
import org.jenkinsci.plugins.ghprb.extensions.comments.GhprbCommentFile;
import org.jenkinsci.plugins.ghprb.extensions.status.GhprbSimpleStatus;
import org.kohsuke.github.GHCommitState;

public abstract class GhprbTriggerBackwardsCompatible
extends Trigger<Job<?, ?>> {
    protected static final int LATEST_VERSION = 3;
    protected Integer configVersion;
    @Deprecated
    protected transient String commentFilePath;
    @Deprecated
    protected transient String msgSuccess;
    @Deprecated
    protected transient String msgFailure;
    @Deprecated
    protected transient String commitStatusContext;
    @Deprecated
    protected transient GhprbGitHubAuth gitHubApiAuth;
    @Deprecated
    protected transient String project;
    @Deprecated
    protected transient Job<?, ?> _project;
    @Deprecated
    protected transient Map<Integer, GhprbPullRequest> pullRequests;

    public abstract DescribableList<GhprbExtension, GhprbExtensionDescriptor> getExtensions();

    public GhprbTriggerBackwardsCompatible(String cron) throws ANTLRException {
        super(cron);
    }

    protected void convertPropertiesToExtensions() {
        if (this.configVersion == null) {
            this.configVersion = 0;
        }
        this.checkCommentsFile();
        this.checkBuildStatusMessages();
        this.checkCommitStatusContext();
        this.configVersion = 3;
    }

    private void checkBuildStatusMessages() {
        if (!StringUtils.isEmpty((String)this.msgFailure) || !StringUtils.isEmpty((String)this.msgSuccess)) {
            ArrayList<GhprbBuildResultMessage> messages = new ArrayList<GhprbBuildResultMessage>(2);
            if (!StringUtils.isEmpty((String)this.msgFailure)) {
                messages.add(new GhprbBuildResultMessage(GHCommitState.FAILURE, this.msgFailure));
                this.msgFailure = null;
            }
            if (!StringUtils.isEmpty((String)this.msgSuccess)) {
                messages.add(new GhprbBuildResultMessage(GHCommitState.SUCCESS, this.msgSuccess));
                this.msgSuccess = null;
            }
            this.addIfMissing(new GhprbBuildStatus(messages));
        }
    }

    private void checkCommentsFile() {
        if (!StringUtils.isEmpty((String)this.commentFilePath)) {
            GhprbCommentFile comments = new GhprbCommentFile(this.commentFilePath);
            this.addIfMissing(comments);
            this.commentFilePath = null;
        }
    }

    private void checkCommitStatusContext() {
        if (this.configVersion < 1) {
            GhprbSimpleStatus status = new GhprbSimpleStatus(this.commitStatusContext);
            this.addIfMissing(status);
        }
    }

    protected void addIfMissing(GhprbExtension ext) {
        if (this.getExtensions().get(((Object)((Object)ext)).getClass()) == null) {
            this.getExtensions().add((Object)ext);
        }
    }
}

