/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb.extensions.comments;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ghprb.Ghprb;
import org.jenkinsci.plugins.ghprb.extensions.GhprbCommentAppender;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class GhprbBuildResultMessage
extends AbstractDescribableImpl<GhprbBuildResultMessage>
implements GhprbCommentAppender {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private final String message;
    private final GHCommitState result;

    @DataBoundConstructor
    public GhprbBuildResultMessage(GHCommitState result, String message) {
        this.result = result;
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public GHCommitState getResult() {
        return this.result;
    }

    @Override
    public String postBuildComment(Run<?, ?> build, TaskListener listener) {
        StringBuilder msg = new StringBuilder();
        GHCommitState state = Ghprb.getState(build);
        String buildMessage = null;
        if (state == this.result) {
            buildMessage = this.message;
            if (StringUtils.isEmpty((String)buildMessage)) {
                return "";
            }
            if (buildMessage.equals("--none--")) {
                return buildMessage;
            }
            String message = Ghprb.replaceMacros(build, listener, buildMessage);
            if (!StringUtils.isEmpty((String)message)) {
                if (msg.length() > 0) {
                    msg.append("\n");
                }
                msg.append(message);
                msg.append("\n");
            }
        }
        return msg.toString();
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends Descriptor<GhprbBuildResultMessage> {
        public boolean isApplicable(Class<?> type) {
            return true;
        }

        public String getDisplayName() {
            return "Add message on Build Status";
        }

        public ListBoxModel doFillResultItems(@QueryParameter String result) {
            GHCommitState[] results;
            ListBoxModel items = new ListBoxModel();
            for (GHCommitState nextResult : results = new GHCommitState[]{GHCommitState.SUCCESS, GHCommitState.ERROR, GHCommitState.FAILURE}) {
                items.add(nextResult.toString(), nextResult.toString());
                if (!result.equals(nextResult.toString())) continue;
                ((ListBoxModel.Option)items.get((int)(items.size() - 1))).selected = true;
            }
            return items;
        }
    }
}

