/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ghprb;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.ghprb.GhprbTrigger;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHUser;

public class GhprbGitHub {
    private static final Logger LOGGER = Logger.getLogger(GhprbGitHub.class.getName());
    private final GhprbTrigger trigger;

    public GhprbGitHub(GhprbTrigger trigger) {
        this.trigger = trigger;
    }

    public boolean isUserMemberOfOrganization(String organisation, GHUser member) {
        boolean orgHasMember = false;
        try {
            GHOrganization org = this.trigger.getGitHub().getOrganization(organisation);
            orgHasMember = org.hasMember(member);
            LOGGER.log(Level.FINE, "org.hasMember(member)? user:{0} org: {1} == {2}", new Object[]{member.getLogin(), organisation, orgHasMember ? "yes" : "no"});
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            return false;
        }
        return orgHasMember;
    }

    public String getBotUserLogin() {
        try {
            return this.trigger.getGitHub().getMyself().getLogin();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

