/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.DataSerializerHook;
import com.hazelcast.nio.serialization.FactoryIdHelper;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.web.SessionState;
import com.hazelcast.web.entryprocessor.DeleteSessionEntryProcessor;
import com.hazelcast.web.entryprocessor.GetAttributeEntryProcessor;
import com.hazelcast.web.entryprocessor.GetAttributeNamesEntryProcessor;
import com.hazelcast.web.entryprocessor.GetSessionStateEntryProcessor;
import com.hazelcast.web.entryprocessor.SessionUpdateEntryProcessor;

public class WebDataSerializerHook
implements DataSerializerHook {
    public static final int F_ID = FactoryIdHelper.getFactoryId((String)"hazelcast.serialization.ds.web", (int)-1000);
    public static final int SESSION_UPDATE = 1;
    public static final int SESSION_DELETE = 2;
    public static final int GET_ATTRIBUTE = 3;
    public static final int GET_ATTRIBUTE_NAMES = 4;
    public static final int GET_SESSION_STATE = 5;
    public static final int SESSION_STATE = 6;

    public DataSerializableFactory createFactory() {
        return new DataSerializableFactory(){

            public IdentifiedDataSerializable create(int typeId) {
                return WebDataSerializerHook.this.getIdentifiedDataSerializable(typeId);
            }
        };
    }

    private IdentifiedDataSerializable getIdentifiedDataSerializable(int typeId) {
        Object dataSerializable;
        switch (typeId) {
            case 1: {
                dataSerializable = new SessionUpdateEntryProcessor();
                break;
            }
            case 2: {
                dataSerializable = new DeleteSessionEntryProcessor();
                break;
            }
            case 3: {
                dataSerializable = new GetAttributeEntryProcessor();
                break;
            }
            case 4: {
                dataSerializable = new GetAttributeNamesEntryProcessor();
                break;
            }
            case 5: {
                dataSerializable = new GetSessionStateEntryProcessor();
                break;
            }
            case 6: {
                dataSerializable = new SessionState();
                break;
            }
            default: {
                dataSerializable = null;
            }
        }
        return dataSerializable;
    }

    public int getFactoryId() {
        return F_ID;
    }
}

