/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web.spring;

import com.hazelcast.web.WebFilter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.session.HttpSessionCreatedEvent;
import org.springframework.security.web.session.HttpSessionDestroyedEvent;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringAwareWebFilter
extends WebFilter {
    protected volatile SessionRegistry sessionRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureSessionRegistryInitialized(ApplicationContext appContext) {
        if (this.sessionRegistry == null) {
            SpringAwareWebFilter springAwareWebFilter = this;
            synchronized (springAwareWebFilter) {
                if (this.sessionRegistry == null) {
                    this.sessionRegistry = (SessionRegistry)appContext.getBean(SessionRegistry.class);
                }
            }
        }
    }

    @Override
    protected WebFilter.HazelcastHttpSession createNewSession(WebFilter.RequestWrapper requestWrapper, String existingSessionId) {
        WebFilter.HazelcastHttpSession session = super.createNewSession(requestWrapper, existingSessionId);
        WebApplicationContext appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        if (appContext != null) {
            this.ensureSessionRegistryInitialized((ApplicationContext)appContext);
            if (this.sessionRegistry != null) {
                String originalSessionId = session.getOriginalSessionId();
                this.sessionRegistry.removeSessionInformation(originalSessionId);
                if (!this.isSessionRegistered(session.getId())) {
                    appContext.publishEvent((ApplicationEvent)new HttpSessionCreatedEvent((HttpSession)session));
                    LOGGER.finest("Published create session event for Spring for session with id " + session.getId());
                }
            }
        }
        return session;
    }

    @Override
    protected void destroySession(WebFilter.HazelcastHttpSession session, boolean invalidate) {
        WebApplicationContext appContext;
        super.destroySession(session, invalidate);
        if (invalidate && (appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext)) != null) {
            this.ensureSessionRegistryInitialized((ApplicationContext)appContext);
            if (this.sessionRegistry != null) {
                String originalSessionId = session.getOriginalSessionId();
                this.sessionRegistry.removeSessionInformation(originalSessionId);
                appContext.publishEvent((ApplicationEvent)new HttpSessionDestroyedEvent((HttpSession)session));
                LOGGER.finest("Published destroy session event for Spring for session with id " + session.getId());
            }
        }
    }

    private boolean isSessionRegistered(String sessionId) {
        if (this.sessionRegistry != null) {
            return this.sessionRegistry.getSessionInformation(sessionId) != null;
        }
        return false;
    }
}

