/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.web.AddSessionEntryProcessor;
import com.hazelcast.web.DestroySessionEntryProcessor;
import com.hazelcast.web.HazelcastInstanceLoader;
import com.hazelcast.web.InvalidateSessionAttributesEntryProcessor;
import com.hazelcast.web.ReferenceSessionEntryProcessor;
import com.hazelcast.web.SessionAttributePredicate;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class WebFilter
implements Filter {
    public static final String WEB_FILTER_ATTRIBUTE_KEY = WebFilter.class.getName();
    protected static final String HAZELCAST_SESSION_ATTRIBUTE_SEPARATOR = "::hz::";
    protected static final ILogger LOGGER = Logger.getLogger(WebFilter.class);
    protected static final LocalCacheEntry NULL_ENTRY = new LocalCacheEntry();
    protected static final String HAZELCAST_REQUEST = "*hazelcast-request";
    protected static final String HAZELCAST_SESSION_COOKIE_NAME = "hazelcast.sessionId";
    protected ServletContext servletContext;
    protected FilterConfig filterConfig;
    private final ConcurrentMap<String, String> originalSessions = new ConcurrentHashMap<String, String>(1000);
    private final ConcurrentMap<String, HazelcastHttpSession> sessions = new ConcurrentHashMap<String, HazelcastHttpSession>(1000);
    private String sessionCookieName = "hazelcast.sessionId";
    private HazelcastInstance hazelcastInstance;
    private String clusterMapName = "none";
    private String sessionCookieDomain;
    private boolean sessionCookieSecure;
    private boolean sessionCookieHttpOnly;
    private boolean stickySession = true;
    private boolean shutdownOnDestroy = true;
    private boolean deferredWrite;
    private Properties properties;

    public WebFilter() {
    }

    public WebFilter(Properties properties) {
        this.properties = properties;
    }

    void destroyOriginalSession(HttpSession originalSession) {
        HazelcastHttpSession hazelSession;
        String hazelcastSessionId = (String)this.originalSessions.remove(originalSession.getId());
        if (hazelcastSessionId != null && (hazelSession = (HazelcastHttpSession)this.sessions.remove(hazelcastSessionId)) != null) {
            this.destroySession(hazelSession, false);
        }
    }

    private static String generateSessionId() {
        char[] chars;
        String id = UuidUtil.buildRandomUuidString();
        StringBuilder sb = new StringBuilder("HZ");
        for (char c : chars = id.toCharArray()) {
            if (c == '-') continue;
            if (Character.isLetter(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public final void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.servletContext = config.getServletContext();
        this.servletContext.setAttribute(WEB_FILTER_ATTRIBUTE_KEY, (Object)this);
        this.initInstance();
        this.initCookieParams();
        this.initParams();
        String mapName = this.getParam("map-name");
        this.clusterMapName = mapName != null ? mapName : "_web_" + this.servletContext.getServletContextName();
        try {
            String sessionTTL = this.getParam("session-ttl-seconds");
            if (sessionTTL != null) {
                Config hzConfig = this.hazelcastInstance.getConfig();
                MapConfig mapConfig = hzConfig.getMapConfig(this.clusterMapName);
                mapConfig.setTimeToLiveSeconds(Integer.parseInt(sessionTTL));
                hzConfig.addMapConfig(mapConfig);
            }
        }
        catch (UnsupportedOperationException ignored) {
            LOGGER.info("client cannot access Config.");
        }
        if (!this.stickySession) {
            this.getClusterMap().addEntryListener((EntryListener)new EntryListener<String, Object>(){

                public void entryAdded(EntryEvent<String, Object> entryEvent) {
                }

                public void entryRemoved(EntryEvent<String, Object> entryEvent) {
                    if (entryEvent.getMember() == null || !entryEvent.getMember().localMember()) {
                        WebFilter.this.removeSessionLocally((String)entryEvent.getKey());
                    }
                }

                public void entryUpdated(EntryEvent<String, Object> entryEvent) {
                }

                public void entryEvicted(EntryEvent<String, Object> entryEvent) {
                    this.entryRemoved(entryEvent);
                }

                public void mapEvicted(MapEvent event) {
                }

                public void mapCleared(MapEvent event) {
                }
            }, false);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("sticky:" + this.stickySession + ", shutdown-on-destroy: " + this.shutdownOnDestroy + ", map-name: " + this.clusterMapName);
        }
    }

    private void initParams() {
        String deferredWriteParam;
        String shutdownOnDestroyParam;
        String stickySessionParam = this.getParam("sticky-session");
        if (stickySessionParam != null) {
            this.stickySession = Boolean.valueOf(stickySessionParam);
        }
        if ((shutdownOnDestroyParam = this.getParam("shutdown-on-destroy")) != null) {
            this.shutdownOnDestroy = Boolean.valueOf(shutdownOnDestroyParam);
        }
        if ((deferredWriteParam = this.getParam("deferred-write")) != null) {
            this.deferredWrite = Boolean.parseBoolean(deferredWriteParam);
        }
    }

    private void initCookieParams() {
        String cookieHttpOnly;
        String cookieSecure;
        String cookieDomain;
        String cookieName = this.getParam("cookie-name");
        if (cookieName != null) {
            this.sessionCookieName = cookieName;
        }
        if ((cookieDomain = this.getParam("cookie-domain")) != null) {
            this.sessionCookieDomain = cookieDomain;
        }
        if ((cookieSecure = this.getParam("cookie-secure")) != null) {
            this.sessionCookieSecure = Boolean.valueOf(cookieSecure);
        }
        if ((cookieHttpOnly = this.getParam("cookie-http-only")) != null) {
            this.sessionCookieHttpOnly = Boolean.valueOf(cookieHttpOnly);
        }
    }

    private void initInstance() throws ServletException {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.setProperty("config-location");
        this.setProperty("instance-name");
        this.setProperty("use-client");
        this.setProperty("client-config-location");
        this.hazelcastInstance = this.getInstance(this.properties);
    }

    private void setProperty(String propertyName) {
        String value = this.getParam(propertyName);
        if (value != null) {
            this.properties.setProperty(propertyName, value);
        }
    }

    private void removeSessionLocally(String sessionId) {
        HazelcastHttpSession hazelSession = (HazelcastHttpSession)this.sessions.remove(sessionId);
        if (hazelSession != null) {
            this.originalSessions.remove(hazelSession.originalSession.getId());
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Destroying session locally " + hazelSession);
            }
            hazelSession.destroy();
        }
    }

    private String extractAttributeKey(String key) {
        return key.substring(key.indexOf(HAZELCAST_SESSION_ATTRIBUTE_SEPARATOR) + HAZELCAST_SESSION_ATTRIBUTE_SEPARATOR.length());
    }

    protected HazelcastHttpSession createNewSession(RequestWrapper requestWrapper, String existingSessionId) {
        String id;
        String string = id = existingSessionId == null ? WebFilter.generateSessionId() : existingSessionId;
        if (requestWrapper.getOriginalSession(false) != null) {
            LOGGER.finest("Original session exists!!!");
        }
        HttpSession originalSession = requestWrapper.getOriginalSession(true);
        HazelcastHttpSession hazelcastSession = this.createHazelcastHttpSession(id, originalSession, this.deferredWrite);
        if (existingSessionId == null) {
            hazelcastSession.setClusterWideNew(true);
            this.getClusterMap().executeOnKey((Object)id, (EntryProcessor)new AddSessionEntryProcessor());
        }
        this.updateSessionMaps(id, originalSession, hazelcastSession);
        this.addSessionCookie(requestWrapper, id);
        return hazelcastSession;
    }

    protected HazelcastHttpSession createHazelcastHttpSession(String id, HttpSession originalSession, boolean deferredWrite) {
        return new HazelcastHttpSession(id, originalSession, deferredWrite);
    }

    private void prepareReloadingSession(HazelcastHttpSession hazelcastSession) {
        if (this.deferredWrite && hazelcastSession != null) {
            Map cache = hazelcastSession.localCache;
            for (LocalCacheEntry cacheEntry : cache.values()) {
                cacheEntry.reload = true;
            }
        }
    }

    private void updateSessionMaps(String sessionId, HttpSession originalSession, HazelcastHttpSession hazelcastSession) {
        this.sessions.put(hazelcastSession.getId(), hazelcastSession);
        String oldHazelcastSessionId = this.originalSessions.put(originalSession.getId(), hazelcastSession.getId());
        if (LOGGER.isFinestEnabled()) {
            if (oldHazelcastSessionId != null) {
                LOGGER.finest("!!! Overwrote an existing hazelcastSessionId " + oldHazelcastSessionId);
            }
            LOGGER.finest("Created new session with id: " + sessionId);
            LOGGER.finest(this.sessions.size() + " is sessions.size and originalSessions.size: " + this.originalSessions.size());
        }
    }

    protected void destroySession(HazelcastHttpSession session, boolean invalidate) {
        boolean invalidated;
        if (LOGGER.isFinestEnabled()) {
            LOGGER.finest("Destroying local session: " + session.getId());
        }
        this.sessions.remove(session.getId());
        this.originalSessions.remove(session.originalSession.getId());
        session.destroy();
        IMap<String, Object> clusterMap = this.getClusterMap();
        if (invalidate) {
            if (LOGGER.isFinestEnabled()) {
                LOGGER.finest("Destroying cluster session: " + session.getId() + " => Ignore-timeout: true");
            }
            clusterMap.delete((Object)session.getId());
            invalidated = true;
        } else {
            Boolean destroyed = (Boolean)clusterMap.executeOnKey((Object)session.getId(), (EntryProcessor)new DestroySessionEntryProcessor());
            boolean bl = invalidated = destroyed != null && destroyed != false;
        }
        if (invalidated) {
            clusterMap.executeOnEntries((EntryProcessor)new InvalidateSessionAttributesEntryProcessor(session.getId()));
        }
    }

    private IMap<String, Object> getClusterMap() {
        return this.hazelcastInstance.getMap(this.clusterMapName);
    }

    private HazelcastHttpSession getSessionWithId(String sessionId) {
        HazelcastHttpSession session = (HazelcastHttpSession)this.sessions.get(sessionId);
        if (session != null && !session.isValid()) {
            this.destroySession(session, true);
            session = null;
        }
        return session;
    }

    private void addSessionCookie(RequestWrapper req, String sessionId) {
        Cookie sessionCookie = new Cookie(this.sessionCookieName, sessionId);
        String path = req.getContextPath();
        if ("".equals(path)) {
            path = "/";
        }
        sessionCookie.setPath(path);
        sessionCookie.setMaxAge(-1);
        if (this.sessionCookieDomain != null) {
            sessionCookie.setDomain(this.sessionCookieDomain);
        }
        if (this.sessionCookieHttpOnly) {
            try {
                sessionCookie.setHttpOnly(true);
            }
            catch (NoSuchMethodError e) {
                LOGGER.info("HttpOnly cookies require a Servlet 3.0+ container. Add the following to the " + this.getClass().getName() + " mapping in web.xml to disable HttpOnly cookies:\n" + "<init-param>\n" + "    <param-name>cookie-http-only</param-name>\n" + "    <param-value>false</param-value>\n" + "</init-param>");
            }
        }
        sessionCookie.setSecure(this.sessionCookieSecure);
        req.res.addCookie(sessionCookie);
    }

    private String getSessionCookie(RequestWrapper req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                String value = cookie.getValue();
                if (!name.equalsIgnoreCase(this.sessionCookieName)) continue;
                return value;
            }
        }
        return null;
    }

    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) {
            chain.doFilter(req, res);
        } else {
            if (req instanceof RequestWrapper) {
                LOGGER.finest("Request is instance of RequestWrapper! Continue...");
                chain.doFilter(req, res);
                return;
            }
            HttpServletRequest httpReq = (HttpServletRequest)req;
            RequestWrapper existingReq = (RequestWrapper)((Object)req.getAttribute(HAZELCAST_REQUEST));
            ResponseWrapper resWrapper = new ResponseWrapper((HttpServletResponse)res);
            RequestWrapper reqWrapper = new RequestWrapper(httpReq, resWrapper);
            if (existingReq != null) {
                reqWrapper.setHazelcastSession(existingReq.hazelcastSession, existingReq.requestedSessionId);
            }
            chain.doFilter((ServletRequest)reqWrapper, (ServletResponse)resWrapper);
            if (existingReq != null) {
                return;
            }
            HazelcastHttpSession session = reqWrapper.getSession(false);
            if (session != null && session.isValid()) {
                if (LOGGER.isFinestEnabled()) {
                    LOGGER.finest("UPDATING SESSION " + session.getId());
                }
                session.sessionDeferredWrite();
            }
        }
    }

    public final void destroy() {
        this.sessions.clear();
        this.originalSessions.clear();
        this.shutdownInstance();
    }

    protected HazelcastInstance getInstance(Properties properties) throws ServletException {
        return HazelcastInstanceLoader.createInstance(this.filterConfig, properties);
    }

    protected void shutdownInstance() {
        if (this.shutdownOnDestroy && this.hazelcastInstance != null) {
            this.hazelcastInstance.getLifecycleService().shutdown();
        }
    }

    private String getParam(String name) {
        if (this.properties != null && this.properties.containsKey(name)) {
            return this.properties.getProperty(name);
        }
        return this.filterConfig.getInitParameter(name);
    }

    protected class HazelcastHttpSession
    implements HttpSession {
        volatile boolean valid = true;
        final String id;
        final HttpSession originalSession;
        private final Map<String, LocalCacheEntry> localCache;
        private final boolean deferredWrite;
        private volatile boolean clusterWideNew;

        public HazelcastHttpSession(String sessionId, HttpSession originalSession, boolean deferredWrite) {
            this.id = sessionId;
            this.originalSession = originalSession;
            this.deferredWrite = deferredWrite;
            this.localCache = deferredWrite ? this.buildLocalCache() : null;
        }

        public HttpSession getOriginalSession() {
            return this.originalSession;
        }

        public String getOriginalSessionId() {
            return this.originalSession != null ? this.originalSession.getId() : null;
        }

        public Object getAttribute(String name) {
            IMap clusterMap = WebFilter.this.getClusterMap();
            if (this.deferredWrite) {
                LocalCacheEntry cacheEntry = this.localCache.get(name);
                if (cacheEntry == null || cacheEntry.reload && !cacheEntry.dirty) {
                    Object value = clusterMap.get((Object)this.buildAttributeName(name));
                    if (value == null) {
                        cacheEntry = NULL_ENTRY;
                    } else {
                        cacheEntry = new LocalCacheEntry();
                        cacheEntry.value = value;
                        cacheEntry.reload = false;
                    }
                    this.localCache.put(name, cacheEntry);
                }
                return cacheEntry != NULL_ENTRY ? cacheEntry.value : null;
            }
            return clusterMap.get((Object)this.buildAttributeName(name));
        }

        public Enumeration<String> getAttributeNames() {
            final Set<String> keys = this.selectKeys();
            return new Enumeration<String>(){
                private final String[] elements;
                private int index;
                {
                    this.elements = keys.toArray(new String[keys.size()]);
                }

                @Override
                public boolean hasMoreElements() {
                    return this.index < this.elements.length;
                }

                @Override
                public String nextElement() {
                    return this.elements[this.index++];
                }
            };
        }

        public String getId() {
            return this.id;
        }

        public ServletContext getServletContext() {
            return WebFilter.this.servletContext;
        }

        @Deprecated
        public HttpSessionContext getSessionContext() {
            return this.originalSession.getSessionContext();
        }

        public Object getValue(String name) {
            return this.getAttribute(name);
        }

        public String[] getValueNames() {
            Set<String> keys = this.selectKeys();
            return keys.toArray(new String[keys.size()]);
        }

        public void invalidate() {
            this.originalSession.invalidate();
            WebFilter.this.destroySession(this, true);
        }

        public boolean isNew() {
            return this.originalSession.isNew() && this.clusterWideNew;
        }

        public void putValue(String name, Object value) {
            this.setAttribute(name, value);
        }

        public void removeAttribute(String name) {
            if (this.deferredWrite) {
                LocalCacheEntry entry = this.localCache.get(name);
                if (entry != null && entry != NULL_ENTRY) {
                    entry.value = null;
                    entry.removed = true;
                    entry.dirty = true;
                }
            } else {
                WebFilter.this.getClusterMap().delete((Object)this.buildAttributeName(name));
            }
        }

        public void setAttribute(String name, Object value) {
            if (name == null) {
                throw new NullPointerException("name must not be null");
            }
            if (value == null) {
                this.removeAttribute(name);
                return;
            }
            if (this.deferredWrite) {
                LocalCacheEntry entry = this.localCache.get(name);
                if (entry == null || entry == NULL_ENTRY) {
                    entry = new LocalCacheEntry();
                    this.localCache.put(name, entry);
                }
                entry.value = value;
                entry.dirty = true;
            } else {
                WebFilter.this.getClusterMap().set((Object)this.buildAttributeName(name), value);
            }
        }

        public void removeValue(String name) {
            this.removeAttribute(name);
        }

        public boolean sessionChanged() {
            if (!this.deferredWrite) {
                return false;
            }
            for (Map.Entry<String, LocalCacheEntry> entry : this.localCache.entrySet()) {
                if (!entry.getValue().dirty) continue;
                return true;
            }
            return false;
        }

        public long getCreationTime() {
            return this.originalSession.getCreationTime();
        }

        public long getLastAccessedTime() {
            return this.originalSession.getLastAccessedTime();
        }

        public int getMaxInactiveInterval() {
            return this.originalSession.getMaxInactiveInterval();
        }

        public void setMaxInactiveInterval(int maxInactiveSeconds) {
            this.originalSession.setMaxInactiveInterval(maxInactiveSeconds);
        }

        void destroy() {
            this.valid = false;
        }

        public boolean isValid() {
            return this.valid;
        }

        private String buildAttributeName(String name) {
            return this.id + WebFilter.HAZELCAST_SESSION_ATTRIBUTE_SEPARATOR + name;
        }

        private Map<String, LocalCacheEntry> buildLocalCache() {
            Set entrySet = WebFilter.this.getClusterMap().entrySet((Predicate)new SessionAttributePredicate(this.id));
            ConcurrentHashMap<String, LocalCacheEntry> cache = new ConcurrentHashMap<String, LocalCacheEntry>();
            for (Map.Entry entry : entrySet) {
                String attributeKey = WebFilter.this.extractAttributeKey((String)entry.getKey());
                LocalCacheEntry cacheEntry = (LocalCacheEntry)cache.get(attributeKey);
                if (cacheEntry == null) {
                    cacheEntry = new LocalCacheEntry();
                    cache.put(attributeKey, cacheEntry);
                }
                if (LOGGER.isFinestEnabled()) {
                    LOGGER.finest("Storing " + attributeKey + " on session " + this.id);
                }
                cacheEntry.value = entry.getValue();
                cacheEntry.dirty = false;
            }
            return cache;
        }

        private void sessionDeferredWrite() {
            if (this.sessionChanged()) {
                IMap clusterMap = WebFilter.this.getClusterMap();
                Iterator<Map.Entry<String, LocalCacheEntry>> iterator = this.localCache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, LocalCacheEntry> entry = iterator.next();
                    if (!entry.getValue().dirty) continue;
                    LocalCacheEntry cacheEntry = entry.getValue();
                    if (cacheEntry.removed) {
                        clusterMap.delete((Object)this.buildAttributeName(entry.getKey()));
                        iterator.remove();
                        continue;
                    }
                    clusterMap.set((Object)this.buildAttributeName(entry.getKey()), cacheEntry.value);
                    cacheEntry.dirty = false;
                }
            }
        }

        private Set<String> selectKeys() {
            HashSet<String> keys = new HashSet<String>();
            if (!this.deferredWrite) {
                for (String qualifiedAttributeKey : WebFilter.this.getClusterMap().keySet((Predicate)new SessionAttributePredicate(this.id))) {
                    keys.add(WebFilter.this.extractAttributeKey(qualifiedAttributeKey));
                }
            } else {
                for (Map.Entry<String, LocalCacheEntry> entry : this.localCache.entrySet()) {
                    if (entry.getValue().removed || entry.getValue() == NULL_ENTRY) continue;
                    keys.add(entry.getKey());
                }
            }
            return keys;
        }

        public void setClusterWideNew(boolean clusterWideNew) {
            this.clusterWideNew = clusterWideNew;
        }
    }

    protected class RequestWrapper
    extends HttpServletRequestWrapper {
        final ResponseWrapper res;
        HazelcastHttpSession hazelcastSession;
        String requestedSessionId;

        public RequestWrapper(HttpServletRequest req, ResponseWrapper res) {
            super(req);
            this.res = res;
            req.setAttribute(WebFilter.HAZELCAST_REQUEST, (Object)this);
        }

        public void setHazelcastSession(HazelcastHttpSession hazelcastSession, String requestedSessionId) {
            this.hazelcastSession = hazelcastSession;
            this.requestedSessionId = requestedSessionId;
        }

        HttpSession getOriginalSession(boolean create) {
            return super.getSession(create);
        }

        public RequestDispatcher getRequestDispatcher(final String path) {
            final ServletRequest original = this.getRequest();
            return new RequestDispatcher(){

                public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    original.getRequestDispatcher(path).forward(servletRequest, servletResponse);
                }

                public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    original.getRequestDispatcher(path).include(servletRequest, servletResponse);
                }
            };
        }

        public HazelcastHttpSession fetchHazelcastSession(boolean create) {
            if (this.requestedSessionId == null) {
                this.requestedSessionId = WebFilter.this.getSessionCookie(this);
                if (this.requestedSessionId == null) {
                    this.requestedSessionId = this.getParameter(WebFilter.HAZELCAST_SESSION_COOKIE_NAME);
                }
            }
            if (this.requestedSessionId != null) {
                this.hazelcastSession = WebFilter.this.getSessionWithId(this.requestedSessionId);
                if (this.hazelcastSession == null) {
                    boolean canOrMustCreate;
                    Boolean existing = (Boolean)WebFilter.this.getClusterMap().executeOnKey((Object)this.requestedSessionId, (EntryProcessor)new ReferenceSessionEntryProcessor());
                    boolean bl = canOrMustCreate = create || !this.res.isCommitted() || this.getOriginalSession(false) != null;
                    if (existing != null && existing.booleanValue() && canOrMustCreate) {
                        this.hazelcastSession = WebFilter.this.createNewSession(this, this.requestedSessionId);
                    }
                }
            }
            return this.hazelcastSession;
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public HazelcastHttpSession getSession(boolean create) {
            if (this.hazelcastSession != null && !this.hazelcastSession.isValid()) {
                LOGGER.finest("Session is invalid!");
                WebFilter.this.destroySession(this.hazelcastSession, true);
                this.hazelcastSession = null;
            } else if (this.hazelcastSession != null) {
                return this.hazelcastSession;
            }
            HttpSession originalSession = this.getOriginalSession(false);
            if (originalSession != null) {
                String hazelcastSessionId = (String)WebFilter.this.originalSessions.get(originalSession.getId());
                if (hazelcastSessionId != null) {
                    this.hazelcastSession = (HazelcastHttpSession)WebFilter.this.sessions.get(hazelcastSessionId);
                    return this.hazelcastSession;
                }
                WebFilter.this.originalSessions.remove(originalSession.getId());
                originalSession.invalidate();
            }
            this.hazelcastSession = this.fetchHazelcastSession(create);
            if (this.hazelcastSession == null && create) {
                this.hazelcastSession = WebFilter.this.createNewSession(this, null);
            }
            if (WebFilter.this.deferredWrite) {
                WebFilter.this.prepareReloadingSession(this.hazelcastSession);
            }
            return this.hazelcastSession;
        }
    }

    protected static class LocalCacheEntry {
        volatile boolean dirty;
        volatile boolean reload;
        boolean removed;
        private Object value;

        protected LocalCacheEntry() {
        }
    }

    protected static class ResponseWrapper
    extends HttpServletResponseWrapper {
        public ResponseWrapper(HttpServletResponse original) {
            super(original);
        }
    }
}

