/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web.tomcat;

import com.hazelcast.core.IMap;
import com.hazelcast.web.tomcat.HazelcastAttribute;
import com.hazelcast.web.tomcat.HazelcastClusterSupport;
import com.hazelcast.web.tomcat.HazelcastSessionFacade;
import com.hazelcast.web.tomcat.LocalRequestId;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;

public class HazelcastValve
extends ValveBase
implements Lifecycle {
    private final AtomicLong lastRequestId = new AtomicLong(0L);
    private final LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        long requestId = this.lastRequestId.incrementAndGet();
        LocalRequestId.set(requestId);
        try {
            IMap<String, HazelcastAttribute> sessionAttrMap = HazelcastClusterSupport.get().getAttributesMap();
            this.getNext().invoke(request, response);
            HazelcastSessionFacade session = (HazelcastSessionFacade)request.getSession(false);
            if (session != null) {
                List<HazelcastAttribute> touchedAttributes = session.getTouchedAttributes(requestId);
                for (HazelcastAttribute attribute : touchedAttributes) {
                    sessionAttrMap.put((Object)attribute.getKey(), (Object)attribute);
                }
            }
        }
        finally {
            LocalRequestId.reset();
        }
    }

    public void start() throws LifecycleException {
        this.lifecycle.fireLifecycleEvent("start", null);
        HazelcastClusterSupport.get().start();
    }

    public void stop() throws LifecycleException {
        this.lifecycle.fireLifecycleEvent("stop", null);
        HazelcastClusterSupport.get().stop();
    }

    public void addLifecycleListener(LifecycleListener l) {
        this.lifecycle.addLifecycleListener(l);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener l) {
        this.lifecycle.removeLifecycleListener(l);
    }
}

