/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web.tomcat;

import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.SerializationHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HazelcastAttribute
implements DataSerializable {
    private String sessionId = null;
    private String name = null;
    private Object value = null;
    private transient Set<Long> touchedByRequest = Collections.synchronizedSet(new HashSet());

    public HazelcastAttribute() {
    }

    public HazelcastAttribute(String sessionId, String name, Object value) {
        this();
        this.sessionId = sessionId;
        this.name = name;
        this.value = value;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void touch(long requestId) {
        this.touchedByRequest.add(requestId);
    }

    public boolean isTouched(long requestId) {
        return this.touchedByRequest.remove(requestId);
    }

    public String getKey() {
        return this.sessionId + "_" + this.name;
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.sessionId);
        out.writeUTF(this.name);
        SerializationHelper.writeObject((DataOutput)out, (Object)this.value);
    }

    public void readData(DataInput in) throws IOException {
        this.sessionId = in.readUTF();
        this.name = in.readUTF();
        this.value = SerializationHelper.readObject((DataInput)in);
    }
}

