/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;

public final class ReflectionUtil {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    private ReflectionUtil() {
    }

    public static <E> E findStaticFieldValue(Class clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            return (E)field.get(null);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static <E> E findStaticFieldValue(String className, String fieldName) {
        try {
            Class<?> clazz = Class.forName(className);
            Field field = clazz.getField(fieldName);
            return (E)field.get(null);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static VarHandle findVarHandle(String fieldName, Class<?> fieldType) {
        try {
            Class<?> classContainingFieldDeclaration = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
            MethodHandles.Lookup l = MethodHandles.privateLookupIn(classContainingFieldDeclaration, LOOKUP);
            return l.findVarHandle(classContainingFieldDeclaration, fieldName, fieldType);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Unable to find a VarHandle for %s of type %s", fieldName, fieldType.getName()), e);
        }
    }
}

