/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.row;

import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.row.Row;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;

public class HeapRow
implements Row,
IdentifiedDataSerializable {
    private Object[] values;

    public HeapRow() {
    }

    public HeapRow(int length) {
        this.values = new Object[length];
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public HeapRow(Object[] values) {
        assert (values != null);
        this.values = values;
    }

    public static HeapRow of(Object ... values) {
        assert (values != null);
        return new HeapRow(values);
    }

    public <T> T get(int index) {
        return (T)this.values[index];
    }

    public int getColumnCount() {
        return this.values.length;
    }

    public void set(int index, Object val) {
        this.values[index] = val;
    }

    public int getFactoryId() {
        return JetSqlSerializerHook.F_ID;
    }

    public int getClassId() {
        return 82;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.values.length);
        for (Object value : this.values) {
            out.writeObject(value);
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        int len = in.readInt();
        this.values = new Object[len];
        for (int i = 0; i < len; ++i) {
            this.values[i] = in.readObject();
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeapRow heapRow = (HeapRow)o;
        return Arrays.equals(this.values, heapRow.values);
    }
}

