/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.string;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.TriExpression;
import com.hazelcast.sql.impl.expression.math.MathFunctionUtils;
import com.hazelcast.sql.impl.expression.string.StringFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;

public class SubstringFunction
extends TriExpression<String> {
    public SubstringFunction() {
    }

    private SubstringFunction(Expression<?> input, Expression<?> start, Expression<?> length) {
        super(input, start, length);
    }

    public static SubstringFunction create(Expression<?> input, Expression<?> start, Expression<?> length) {
        return new SubstringFunction(input, start, length);
    }

    @Override
    public String eval(Row row, ExpressionEvalContext context) {
        Integer length;
        String input;
        try {
            input = StringFunctionUtils.asVarchar(this.operand1, row, context);
        }
        catch (Exception e) {
            throw QueryException.dataException((String)("Failed to get value of input operand of SUBSTRING function: " + e.getMessage()), (Throwable)e);
        }
        if (input == null) {
            return null;
        }
        Integer start = MathFunctionUtils.asInt(this.operand2, row, context);
        if (start == null) {
            return null;
        }
        if (start < 1) {
            throw QueryException.dataException((String)"SUBSTRING \"start\" operand must be positive");
        }
        int adjustedStart = start - 1;
        if (adjustedStart >= input.length()) {
            return "";
        }
        if (this.operand3 != null) {
            length = MathFunctionUtils.asInt(this.operand3, row, context);
            if (length == null) {
                return null;
            }
        } else {
            length = null;
        }
        if (length == null) {
            return adjustedStart > 0 ? input.substring(adjustedStart) : input;
        }
        if (length < 0) {
            throw QueryException.dataException((String)"SUBSTRING \"length\" operand cannot be negative");
        }
        if (length == 0) {
            return "";
        }
        if (adjustedStart + length > input.length()) {
            return adjustedStart > 0 ? input.substring(adjustedStart) : input;
        }
        return input.substring(adjustedStart, adjustedStart + length);
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.VARCHAR;
    }

    public int getClassId() {
        return 64;
    }
}

