/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.UniExpression;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Objects;

public abstract class UniExpressionWithType<T>
extends UniExpression<T> {
    protected QueryDataType resultType;

    protected UniExpressionWithType() {
    }

    protected UniExpressionWithType(Expression<?> operand, QueryDataType resultType) {
        this.operand = operand;
        this.resultType = resultType;
    }

    @Override
    public QueryDataType getType() {
        return this.resultType;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject((Object)this.resultType);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.resultType = (QueryDataType)in.readObject();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resultType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UniExpressionWithType that = (UniExpressionWithType)o;
        return this.resultType.equals(that.resultType);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{operand=" + String.valueOf(this.operand) + ", resultType=" + String.valueOf(this.resultType) + "}";
    }
}

